/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Optional;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConfigurationModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel operationModel) {
                if (owner instanceof ConfigurationModel) {
                    Class configType = MuleExtensionUtils.getConfigurationFactory((ConfigurationModel)owner).getObjectType();
                    Optional<Class> operationConfigParameterType = operationModel.getModelProperty(ConfigTypeModelProperty.class).map(modelProperty -> modelProperty.getConfigType());
                    if (operationConfigParameterType.isPresent() && !operationConfigParameterType.get().isAssignableFrom(configType)) {
                        problemsReporter.addError(new Problem((NamedObject)operationModel, String.format("Operation '%s' requires a configuration of type '%s'. However, the operation is reachable from configuration '%s' of incompatible type '%s'.", operationModel.getName(), operationConfigParameterType.get().getName(), ((ConfigurationModel)owner).getName(), configType.getName())));
                    }
                }
            }
        }.walk(model);
    }
}

