/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public final class ImplicitObjectUtils {
    private ImplicitObjectUtils() {
    }

    public static ResolverSet buildImplicitResolverSet(ParameterizedModel parameterizedModel, MuleContext muleContext) {
        ResolverSet resolverSet = new ResolverSet();
        ParametersResolver parametersResolver = ParametersResolver.fromDefaultValues(parameterizedModel, muleContext);
        for (ParameterModel parameterModel : parameterizedModel.getAllParameterModels()) {
            ValueResolver<Object> resolver;
            Object defaultValue = parameterModel.getDefaultValue();
            ValueResolver<Object> valueResolver = resolver = defaultValue != null ? new TypeSafeExpressionValueResolver((String)defaultValue, JavaTypeUtils.getType((MetadataType)parameterModel.getType()), muleContext) : new StaticValueResolver<Object>(null);
            if (parameterModel.getModelProperty(NullSafeModelProperty.class).isPresent()) {
                resolver = NullSafeValueResolverWrapper.of(resolver, parameterModel.getType(), muleContext, parametersResolver);
            }
            resolverSet.add(parameterModel.getName(), resolver);
        }
        return resolverSet;
    }

    public static <T extends ParameterizedModel> T getFirstImplicit(List<T> models) {
        return (T)((ParameterizedModel)models.stream().filter(ImplicitObjectUtils::canBeUsedImplicitly).findFirst().orElse(null));
    }

    private static boolean canBeUsedImplicitly(ParameterizedModel parameterizedModel) {
        return parameterizedModel.getAllParameterModels().stream().noneMatch(p -> p.isRequired() && p.getDefaultValue() == null);
    }
}

