/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.tooling;

import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ExtensionConnectivityTestingStrategy
implements ConnectivityTestingStrategy {
    @Inject
    private MuleContext muleContext;
    @Inject
    private ConnectionManager connectionManager;

    public ExtensionConnectivityTestingStrategy() {
    }

    ExtensionConnectivityTestingStrategy(ConnectionManager connectionManager, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.connectionManager = connectionManager;
    }

    public ConnectionValidationResult testConnectivity(Object connectivityTestingObject) {
        try {
            if (connectivityTestingObject instanceof ConnectionProviderResolver) {
                ConnectionProvider connectionProvider = ((ConnectionProviderResolver)connectivityTestingObject).resolve(MuleExtensionUtils.getInitialiserEvent(this.muleContext));
                return this.connectionManager.testConnectivity(connectionProvider);
            }
            if (connectivityTestingObject instanceof ConfigurationProvider) {
                ConfigurationProvider configurationProvider = (ConfigurationProvider)connectivityTestingObject;
                ConfigurationInstance configurationInstance = configurationProvider.get((Object)MuleExtensionUtils.getInitialiserEvent(this.muleContext));
                return this.connectionManager.testConnectivity(configurationInstance);
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("testConnectivity was invoked with an object type %s not supported.", connectivityTestingObject.getClass().getName())));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)"Failed to obtain connectivity testing object", (Exception)e);
        }
    }

    public boolean accepts(Object connectivityTestingObject) {
        return connectivityTestingObject instanceof ConnectionProviderResolver || connectivityTestingObject instanceof ConfigurationProvider;
    }
}

