/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.DefaultEncodingAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.DefaultEncodingModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ParametersResolver
implements ObjectTypeParametersResolver {
    private final MuleContext muleContext;
    private final Map<String, ?> parameters;

    private ParametersResolver(MuleContext muleContext, Map<String, ?> parameters) {
        this.muleContext = muleContext;
        this.parameters = parameters;
    }

    public static ParametersResolver fromValues(Map<String, ?> parameters, MuleContext muleContext) {
        return new ParametersResolver(muleContext, parameters);
    }

    public static ParametersResolver fromDefaultValues(ParameterizedModel parameterizedModel, MuleContext muleContext) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        for (ParameterModel model : parameterizedModel.getAllParameterModels()) {
            parameterValues.put(model.getName(), model.getDefaultValue());
        }
        return new ParametersResolver(muleContext, parameterValues);
    }

    public ResolverSet getParametersAsResolverSet(ParameterizedModel model) throws ConfigurationException {
        List<ParameterGroupModel> inlineGroups = this.getInlineGroups(model);
        ResolverSet resolverSet = this.getParametersAsResolverSet(model, this.getFlatParameters(inlineGroups, model.getAllParameterModels()));
        for (ParameterGroupModel group : inlineGroups) {
            String containerName = IntrospectionUtils.getContainerName(group.getModelProperty(ParameterGroupModelProperty.class).map(mp -> mp.getDescriptor().getContainer()).orElseThrow(() -> new IllegalArgumentException(String.format("Missing ParameterGroup information for group '%s'", group.getName()))));
            if (!this.parameters.containsKey(containerName)) continue;
            resolverSet.add(containerName, this.toValueResolver(this.parameters.get(containerName), group.getModelProperties()));
        }
        return resolverSet;
    }

    public ResolverSet getParametersAsResolverSet(ParameterizedModel model, List<ParameterModel> parameterModels) throws ConfigurationException {
        ResolverSet resolverSet = new ResolverSet();
        parameterModels.forEach(p -> {
            String parameterName = IntrospectionUtils.getMemberName((EnrichableModel)p, p.getName());
            ValueResolver<Object> resolver = this.parameters.containsKey(parameterName) ? this.toValueResolver(this.parameters.get(parameterName), p.getModelProperties()) : this.getDefaultValueResolver(p.getModelProperty(DefaultEncodingModelProperty.class).isPresent(), () -> {
                Object defaultValue = p.getDefaultValue();
                if (defaultValue instanceof String) {
                    return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue, p, this.muleContext);
                }
                if (defaultValue != null) {
                    return new StaticValueResolver<Object>(defaultValue);
                }
                return null;
            });
            if (MuleExtensionUtils.isNullSafe(p)) {
                MetadataType type = ((NullSafeModelProperty)p.getModelProperty(NullSafeModelProperty.class).get()).defaultType();
                StaticValueResolver<Object> delegate = resolver != null ? resolver : new StaticValueResolver<Object>(null);
                resolver = NullSafeValueResolverWrapper.of(delegate, type, this.muleContext, this);
            }
            if (resolver != null) {
                resolverSet.add(parameterName, resolver);
            } else if (p.isRequired()) {
                throw new IllegalStateException(String.format("Parameter '%s' from the %s '%s' is required but is not set", parameterName, NameUtils.getComponentModelTypeName((Object)model), NameUtils.getModelName((Object)model)));
            }
        });
        this.checkParameterGroupExclusiveness(model, this.parameters.keySet());
        return resolverSet;
    }

    private List<ParameterGroupModel> getInlineGroups(ParameterizedModel model) {
        return model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).collect(Collectors.toList());
    }

    private List<ParameterModel> getFlatParameters(List<ParameterGroupModel> inlineGroups, List<ParameterModel> parameters) {
        return parameters.stream().filter(p -> inlineGroups.stream().noneMatch(g -> g.getParameterModels().contains(p))).collect(Collectors.toList());
    }

    @Override
    public void resolveParameterGroups(ObjectType objectType, DefaultObjectBuilder builder) {
        Class objectClass = JavaTypeUtils.getType((MetadataType)objectType);
        objectType.getFields().stream().filter(ExtensionMetadataTypeUtils::isParameterGroup).forEach(groupField -> {
            if (!(groupField.getValue() instanceof ObjectType)) {
                return;
            }
            ObjectType groupType = (ObjectType)groupField.getValue();
            Field objectField = this.getField(objectClass, MetadataTypeUtils.getLocalPart((ObjectFieldType)groupField));
            DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(JavaTypeUtils.getType((MetadataType)groupField.getValue()));
            builder.addPropertyResolver(objectField.getName(), new ObjectBuilderValueResolver(groupBuilder));
            this.resolveParameters(groupType, groupBuilder);
            this.resolveParameterGroups(groupType, groupBuilder);
        });
    }

    @Override
    public void resolveParameters(ObjectType objectType, DefaultObjectBuilder builder) {
        Class objectClass = JavaTypeUtils.getType((MetadataType)objectType);
        boolean isParameterGroup = ExtensionMetadataTypeUtils.isParameterGroup((MetadataType)objectType);
        objectType.getFields().forEach(field -> {
            String key = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
            ValueResolver<Object> valueResolver = null;
            Field objectField = this.getField(objectClass, key);
            if (this.parameters.containsKey(key)) {
                valueResolver = this.toValueResolver(this.parameters.get(key));
            } else if (!isParameterGroup) {
                valueResolver = this.getDefaultValueResolver(field.getAnnotation(DefaultEncodingAnnotation.class).isPresent(), () -> MetadataTypeUtils.getDefaultValue((MetadataType)field).isPresent() ? ResolverUtils.getFieldDefaultValueValueResolver(field, this.muleContext) : null);
            }
            Optional nullSafe = field.getAnnotation(NullSafeTypeAnnotation.class);
            if (nullSafe.isPresent()) {
                StaticValueResolver<Object> delegate = valueResolver != null ? valueResolver : new StaticValueResolver<Object>(null);
                MetadataType type = IntrospectionUtils.getMetadataType(((NullSafeTypeAnnotation)nullSafe.get()).getType(), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader());
                valueResolver = NullSafeValueResolverWrapper.of(delegate, type, this.muleContext, this);
            }
            if (valueResolver != null) {
                builder.addPropertyResolver(objectField.getName(), valueResolver);
            } else if (field.isRequired() && !ExtensionMetadataTypeUtils.isParameterGroup((MetadataType)field)) {
                throw new IllegalStateException(String.format("The object '%s' requires the parameter '%s' but is not set", objectClass.getSimpleName(), objectField.getName()));
            }
        });
    }

    private Field getField(Class<?> objectClass, String key) {
        return IntrospectionUtils.getFieldByNameOrAlias(objectClass, key).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Class '%s' does not contain field %s", objectClass.getName(), key)));
    }

    public void checkParameterGroupExclusiveness(ParameterizedModel model, Set<String> resolverKeys) throws ConfigurationException {
        for (ParameterGroupModel group : model.getParameterGroupModels()) {
            for (ExclusiveParametersModel exclusiveModel : group.getExclusiveParametersModels()) {
                Collection definedExclusiveParameters = CollectionUtils.intersection((Collection)exclusiveModel.getExclusiveParameterNames(), resolverKeys);
                if (definedExclusiveParameters.isEmpty() && exclusiveModel.isOneRequired()) {
                    throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Parameter group '%s' requires that one of its optional parameters should be set but all of them are missing. One of the following should be set: [%s]", group.getName(), Joiner.on((String)", ").join((Iterable)exclusiveModel.getExclusiveParameterNames()))));
                }
                if (definedExclusiveParameters.size() <= 1) continue;
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("In %s '%s', the following parameters cannot be set at the same time: [%s]", NameUtils.getComponentModelTypeName((Object)model), NameUtils.getModelName((Object)model), Joiner.on((String)", ").join((Iterable)definedExclusiveParameters))));
            }
        }
    }

    private ValueResolver<?> toValueResolver(Object value) {
        return this.toValueResolver(value, Collections.emptySet());
    }

    private ValueResolver<?> toValueResolver(Object value, Set<ModelProperty> modelProperties) {
        ValueResolver<Object> resolver = value instanceof ValueResolver ? (ValueResolver<?>)value : (value instanceof Collection ? this.getCollectionResolver((Collection)value) : (value instanceof Map ? this.getMapResolver((Map)value) : (IntrospectionUtils.isParameterResolver(modelProperties) ? new StaticValueResolver<StaticParameterResolver<Object>>(new StaticParameterResolver<Object>(value)) : (IntrospectionUtils.isTypedValue(modelProperties) ? new StaticValueResolver<TypedValue>(new TypedValue(value, DataType.fromObject((Object)value))) : new StaticValueResolver<Object>(value)))));
        return resolver;
    }

    private ValueResolver<?> getMapResolver(Map<Object, Object> value) {
        LinkedHashMap normalizedMap = new LinkedHashMap(value.size());
        value.forEach((key, entryValue) -> normalizedMap.put(this.toValueResolver(key), this.toValueResolver(entryValue)));
        return MapValueResolver.of(value.getClass(), ImmutableList.copyOf(normalizedMap.keySet()), ImmutableList.copyOf(normalizedMap.values()));
    }

    private ValueResolver<?> getCollectionResolver(Collection<?> collection) {
        return CollectionValueResolver.of(collection.getClass(), (List)collection.stream().map(p -> this.toValueResolver(p)).collect(new ImmutableListCollector()));
    }

    private ValueResolver<?> getDefaultValueResolver(boolean hasDefaultEncoding, Supplier<ValueResolver<?>> supplier) {
        return hasDefaultEncoding ? new StaticValueResolver<String>(this.muleContext.getConfiguration().getDefaultEncoding()) : supplier.get();
    }
}

