/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.loader.java.property.InterceptingModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptingOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.PagedOperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class OperationMessageProcessorBuilder {
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final PolicyManager policyManager;
    private final MuleContext muleContext;
    private ConfigurationProvider configurationProvider;
    private Map<String, ?> parameters;
    private String target;
    private CursorStreamProviderFactory cursorStreamProviderFactory;

    public OperationMessageProcessorBuilder(ExtensionModel extensionModel, OperationModel operationModel, PolicyManager policyManager, MuleContext muleContext) {
        Preconditions.checkArgument((extensionModel != null ? 1 : 0) != 0, (String)"ExtensionModel cannot be null");
        Preconditions.checkArgument((operationModel != null ? 1 : 0) != 0, (String)"OperationModel cannot be null");
        Preconditions.checkArgument((policyManager != null ? 1 : 0) != 0, (String)"PolicyManager cannot be null");
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"muleContext cannot be null");
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.policyManager = policyManager;
        this.muleContext = muleContext;
    }

    public OperationMessageProcessorBuilder setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        return this;
    }

    public OperationMessageProcessorBuilder setParameters(Map<String, ?> parameters) {
        this.parameters = parameters != null ? parameters : new HashMap();
        return this;
    }

    public OperationMessageProcessorBuilder setTarget(String target) {
        this.target = target;
        return this;
    }

    public OperationMessageProcessorBuilder setCursorStreamProviderFactory(CursorStreamProviderFactory cursorStreamProviderFactory) {
        this.cursorStreamProviderFactory = cursorStreamProviderFactory;
        return this;
    }

    public OperationMessageProcessor build() {
        return (OperationMessageProcessor)((Object)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> {
            try {
                ResolverSet resolverSet = ParametersResolver.fromValues(this.parameters, this.muleContext).getParametersAsResolverSet((ParameterizedModel)this.operationModel);
                ExtensionManager extensionManager = this.muleContext.getExtensionManager();
                OperationMessageProcessor processor = this.operationModel.getModelProperty(InterceptingModelProperty.class).isPresent() ? new InterceptingOperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, resolverSet, this.cursorStreamProviderFactory, extensionManager, this.policyManager) : (this.operationModel.getModelProperty(PagedOperationModelProperty.class).isPresent() ? new PagedOperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, resolverSet, this.cursorStreamProviderFactory, extensionManager, this.policyManager) : new OperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, resolverSet, this.cursorStreamProviderFactory, extensionManager, this.policyManager));
                this.muleContext.getInjector().inject((Object)processor);
                return processor;
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }));
    }
}

