/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.InterceptableOperationExecutorWrapper;
import org.mule.runtime.module.extension.internal.runtime.execution.ReactorCompletionCallback;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class ReactiveOperationExecutionWrapper
implements OperationExecutor,
Lifecycle,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptableOperationExecutorWrapper.class);
    private final OperationExecutor delegate;
    private MuleContext muleContext;

    public ReactiveOperationExecutionWrapper(OperationExecutor delegate) {
        this.delegate = delegate;
    }

    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        if (((OperationModel)executionContext.getComponentModel()).isBlocking()) {
            return this.delegate.execute(executionContext);
        }
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        return Mono.create(sink -> {
            ReactorCompletionCallback callback = new ReactorCompletionCallback((MonoSink<Object>)sink, context.getEvent());
            context.setVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM", callback);
            try {
                this.delegate.execute(executionContext);
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        });
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.delegate, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.delegate);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.delegate);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.delegate, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

