/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.type.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.module.extension.internal.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.internal.loader.java.type.OperationContainerElement;
import org.mule.runtime.module.extension.internal.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ConnectionProviderTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationContainerWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.SourceTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

abstract class ComponentWrapper
extends TypeWrapper
implements ComponentElement {
    ComponentWrapper(Class<?> aClass) {
        super(aClass);
    }

    @Override
    public List<SourceElement> getSources() {
        Optional<Sources> optionalSources = this.getAnnotation(Sources.class);
        if (optionalSources.isPresent()) {
            return Arrays.stream(optionalSources.get().value()).map(SourceTypeWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<OperationContainerElement> getOperationContainers() {
        Optional<Operations> optionalOperations = this.getAnnotation(Operations.class);
        if (optionalOperations.isPresent()) {
            return Arrays.stream(optionalOperations.get().value()).map(OperationContainerWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConnectionProviderElement> getConnectionProviders() {
        Optional<ConnectionProviders> optionalProviders = this.getAnnotation(ConnectionProviders.class);
        if (optionalProviders.isPresent()) {
            return Arrays.stream(optionalProviders.get().value()).map(ConnectionProviderTypeWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

