/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.JavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.internal.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithMessageSources;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

final class SourceModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String SOURCE = "Source";
    private final Map<Class<?>, SourceDeclarer> sourceDeclarers = new HashMap();

    SourceModelLoaderDelegate(JavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareMessageSources(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer declarer, WithMessageSources typeComponent) {
        typeComponent.getSources().forEach(source -> this.declareMessageSource(extensionDeclarer, declarer, (SourceElement)source, true));
    }

    void declareMessageSource(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer declarer, SourceElement sourceType, boolean supportsConfig) {
        if (IntrospectionUtils.isLifecycle(sourceType.getDeclaringClass())) {
            throw new IllegalSourceModelDefinitionException(String.format("Source class '%s' implements a lifecycle interface. Sources are not allowed to", sourceType.getDeclaringClass().getName()));
        }
        Optional<ExtensionParameter> configParameter = this.loader.getConfigParameter(sourceType);
        Optional<ExtensionParameter> connectionParameter = this.loader.getConnectionParameter(sourceType);
        if (this.loader.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter)) {
            throw new IllegalSourceModelDefinitionException(String.format("Source '%s' is defined at the extension level but it requires a config parameter. Remove such parameter or move the source to the proper config", sourceType.getName()));
        }
        HasSourceDeclarer actualDeclarer = (HasSourceDeclarer)this.loader.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, connectionParameter);
        SourceDeclarer source = this.sourceDeclarers.get(sourceType.getDeclaringClass());
        if (source != null) {
            actualDeclarer.withMessageSource(source);
            return;
        }
        source = actualDeclarer.withMessageSource(sourceType.getAlias());
        List<Type> sourceGenerics = sourceType.getSuperClassGenerics();
        if (sourceGenerics.size() != 2) {
            throw new IllegalModelDefinitionException(String.format("Message source class '%s' was expected to have 2 generic types (one for the Payload type and another for the Attributes type) but %d were found", sourceType.getName(), sourceGenerics.size()));
        }
        ((SourceDeclarer)((SourceDeclarer)((SourceDeclarer)source.hasResponse(sourceType.isAnnotatedWith(EmitsResponse.class)).requiresConnection(connectionParameter.isPresent())).transactional(false)).withModelProperty((ModelProperty)new SourceFactoryModelProperty(new DefaultSourceFactory(sourceType.getDeclaringClass())))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(sourceType.getDeclaringClass()));
        this.resolveOutputTypes(source, sourceGenerics);
        this.loader.addExceptionEnricher(sourceType, (HasModelProperties)source);
        this.declareSourceParameters(sourceType, source);
        this.declareSourceCallback(sourceType, source);
        this.sourceDeclarers.put(sourceType.getDeclaringClass(), source);
    }

    private void resolveOutputTypes(SourceDeclarer source, List<Type> sourceGenerics) {
        source.withOutput().ofType(IntrospectionUtils.getSourceReturnType(sourceGenerics.get(0), this.getTypeLoader()));
        source.withOutputAttributes().ofType(this.getTypeLoader().load(sourceGenerics.get(1)));
    }

    private void declareSourceParameters(SourceElement sourceType, SourceDeclarer source) {
        this.loader.declareFieldBasedParameters((ParameterizedDeclarer)source, sourceType.getParameters(), new ParameterDeclarationContext(SOURCE, (NamedDeclaration)source.getDeclaration())).forEach(p -> p.withExpressionSupport(ExpressionSupport.NOT_SUPPORTED));
    }

    private void declareSourceCallback(SourceElement sourceType, SourceDeclarer source) {
        Optional<MethodElement> onResponseMethod = sourceType.getOnResponseMethod();
        Optional<MethodElement> onErrorMethod = sourceType.getOnErrorMethod();
        this.declareSourceCallbackParameters(source, onResponseMethod, () -> ((SourceDeclarer)source).onSuccess());
        this.declareSourceCallbackParameters(source, onErrorMethod, () -> ((SourceDeclarer)source).onError());
        source.withModelProperty((ModelProperty)new SourceCallbackModelProperty(this.getMethod(onResponseMethod), this.getMethod(onErrorMethod)));
    }

    private void declareSourceCallbackParameters(SourceDeclarer source, Optional<MethodElement> sourceCallback, Supplier<ParameterizedDeclarer> callback) {
        sourceCallback.ifPresent(method -> this.loader.declareMethodBasedParameters((ParameterizedDeclarer)callback.get(), method.getParameters(), new ParameterDeclarationContext(SOURCE, (NamedDeclaration)source.getDeclaration())));
    }

    private Optional<Method> getMethod(Optional<MethodElement> method) {
        return method.map(MethodElement::getMethod);
    }
}

