/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.JavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.TypeAwareConfigurationFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;

final class ConfigModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String CONFIGURATION = "Configuration";

    ConfigModelLoaderDelegate(JavaModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareConfigurations(ExtensionDeclarer declaration, ExtensionElement extensionElement) {
        List<ConfigurationElement> configurations = extensionElement.getConfigurations();
        if (configurations.isEmpty()) {
            this.declareConfiguration(declaration, extensionElement, extensionElement);
        } else {
            for (ConfigurationElement configuration : configurations) {
                this.declareConfiguration(declaration, extensionElement, configuration);
            }
        }
    }

    private void declareConfiguration(ExtensionDeclarer declarer, ExtensionElement extensionType, ComponentElement configurationType) {
        ConfigurationDeclarer configurationDeclarer;
        this.checkConfigurationIsNotAnOperation(configurationType.getDeclaringClass());
        Optional<Configuration> configurationAnnotation = configurationType.getAnnotation(Configuration.class);
        if (configurationAnnotation.isPresent()) {
            Configuration configuration = configurationAnnotation.get();
            configurationDeclarer = declarer.withConfig(configuration.name()).describedAs(configuration.description());
        } else {
            configurationDeclarer = declarer.withConfig("config").describedAs("Default configuration");
        }
        configurationDeclarer.withModelProperty((ModelProperty)new ConfigurationFactoryModelProperty(new TypeAwareConfigurationFactory(configurationType.getDeclaringClass(), extensionType.getDeclaringClass().getClassLoader()))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(configurationType.getDeclaringClass()));
        this.loader.parseExternalLibs(configurationType, (DeclaresExternalLibraries)configurationDeclarer);
        this.loader.declareFieldBasedParameters((ParameterizedDeclarer)configurationDeclarer, configurationType.getParameters(), new ParameterDeclarationContext(CONFIGURATION, (NamedDeclaration)configurationDeclarer.getDeclaration()));
        this.getOperationLoaderDelegate().declareOperations(declarer, (HasOperationDeclarer)configurationDeclarer, configurationType);
        this.getSourceModelLoaderDelegate().declareMessageSources(declarer, (HasSourceDeclarer)configurationDeclarer, configurationType);
        this.getConnectionProviderModelLoaderDelegate().declareConnectionProviders((HasConnectionProviderDeclarer)configurationDeclarer, configurationType);
    }

    private void checkConfigurationIsNotAnOperation(Class<?> configurationType) {
        Class<?>[] operationClasses;
        for (Class<?> operationClass : operationClasses = this.loader.getOperationClasses(this.getExtensionType())) {
            if (!configurationType.isAssignableFrom(operationClass) && !operationClass.isAssignableFrom(configurationType)) continue;
            throw new IllegalConfigurationModelDefinitionException(String.format("Configuration class '%s' cannot be the same class (nor a derivative) of any operation class '%s", configurationType.getName(), operationClass.getName()));
        }
    }
}

