/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.message.NullAttributes;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.model.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.model.property.ConnectivityModelProperty;
import org.mule.runtime.extension.api.runtime.InterceptorFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceFactory;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.module.extension.internal.model.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.model.property.InterceptorsModelProperty;
import org.mule.runtime.module.extension.internal.model.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.model.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.OperationExecutorModelProperty;
import org.mule.runtime.module.extension.internal.model.property.RequireNameField;
import org.mule.runtime.module.extension.internal.model.property.SourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationExecutorFactoryWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.springframework.util.ReflectionUtils;

public class MuleExtensionUtils {
    public static Message toMessage(Result result) {
        return MuleExtensionUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY));
    }

    public static Message toMessage(Result result, MediaType mediaType) {
        return Message.builder().payload(result.getOutput()).mediaType(mediaType).attributes((Attributes)result.getAttributes().orElse(NullAttributes.NULL_ATTRIBUTES)).build();
    }

    public static <T> boolean hasAnyDynamic(Iterable<ValueResolver<T>> resolvers) {
        for (ValueResolver<T> resolver : resolvers) {
            if (!resolver.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullSafe(ParameterModel parameterModel) {
        return parameterModel.getModelProperties().stream().anyMatch(p -> p instanceof NullSafeModelProperty);
    }

    public static List<ConnectionProviderModel> getAllConnectionProviders(ExtensionModel extensionModel, ConfigurationModel configurationModel) {
        return ImmutableList.builder().addAll((Iterable)configurationModel.getConnectionProviders()).addAll((Iterable)extensionModel.getConnectionProviders()).build();
    }

    public static <T extends NamedObject> List<T> alphaSortDescribedList(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        Collections.sort(list, new NamedObjectComparator());
        return list;
    }

    public static List<Interceptor> createInterceptors(EnrichableModel model) {
        return model.getModelProperty(InterceptorsModelProperty.class).map(p -> MuleExtensionUtils.createInterceptors(p.getInterceptorFactories())).orElse((List)ImmutableList.of());
    }

    public static void addInterceptorFactory(BaseDeclaration declaration, InterceptorFactory interceptorFactory) {
        MuleExtensionUtils.getOrCreateInterceptorModelProperty(declaration).addInterceptorFactory(interceptorFactory);
    }

    public static void addInterceptorFactory(BaseDeclaration declaration, InterceptorFactory interceptorFactory, int position) {
        MuleExtensionUtils.getOrCreateInterceptorModelProperty(declaration).addInterceptorFactory(interceptorFactory, position);
    }

    private static InterceptorsModelProperty getOrCreateInterceptorModelProperty(BaseDeclaration declaration) {
        InterceptorsModelProperty property = declaration.getModelProperty(InterceptorsModelProperty.class).orElse(null);
        if (property == null) {
            property = new InterceptorsModelProperty(Collections.emptyList());
            declaration.addModelProperty((ModelProperty)property);
        }
        return property;
    }

    public static List<Interceptor> createInterceptors(List<InterceptorFactory> interceptorFactories) {
        if (CollectionUtils.isEmpty(interceptorFactories)) {
            return ImmutableList.of();
        }
        return (List)interceptorFactories.stream().map(InterceptorFactory::createInterceptor).collect(new ImmutableListCollector());
    }

    public static String getDefaultValue(Optional optional) {
        if (optional == null) {
            return null;
        }
        String defaultValue = optional.defaultValue();
        return "THIS IS A SPECIAL NULL VALUE - DO NOT USE".equals(defaultValue) ? null : defaultValue;
    }

    public static Object getDefaultValue(AccessibleObject object) {
        return MuleExtensionUtils.getDefaultValue(object.getAnnotation(Optional.class));
    }

    public static Event getInitialiserEvent() {
        return MuleExtensionUtils.getInitialiserEvent(null);
    }

    public static Event getInitialiserEvent(final MuleContext muleContext) {
        FlowConstruct flowConstruct = new FlowConstruct(){

            public MuleContext getMuleContext() {
                return muleContext;
            }

            public String getServerId() {
                return "InitialiserServer";
            }

            public String getUniqueIdString() {
                return UUID.getUUID();
            }

            public String getName() {
                return "InitialiserEventFlow";
            }

            public LifecycleState getLifecycleState() {
                return null;
            }

            public MessagingExceptionHandler getExceptionListener() {
                return null;
            }

            public FlowConstructStatistics getStatistics() {
                return null;
            }
        };
        return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flowConstruct, (String)"InitializerEvent")).message(InternalMessage.builder().nullPayload().build()).exchangePattern(MessageExchangePattern.REQUEST_RESPONSE).flow(flowConstruct).build();
    }

    public static Method getImplementingMethod(OperationDeclaration operationDeclaration) {
        return operationDeclaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).orElse(null);
    }

    public static ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElseThrow(() -> MuleExtensionUtils.noClassLoaderException(extensionModel.getName()));
    }

    public static <T> T withExtensionClassLoader(ExtensionModel extensionModel, Callable<T> callable) throws Exception {
        return (T)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(extensionModel), callable);
    }

    public static void injectConfigName(EnrichableModel model, Object target, String configName) {
        model.getModelProperty(RequireNameField.class).ifPresent(property -> {
            Field configNameField = property.getConfigNameField();
            if (!configNameField.getDeclaringClass().isInstance(target)) {
                throw new IllegalConfigurationModelDefinitionException(String.format("field '%s' is annotated with @%s but not defined on an instance of type '%s'", configNameField.toString(), ConfigName.class.getSimpleName(), target.getClass().getName()));
            }
            configNameField.setAccessible(true);
            ReflectionUtils.setField((Field)configNameField, (Object)target, (Object)configName);
        });
    }

    public static byte toActionCode(OperationTransactionalAction action) {
        switch (action) {
            case ALWAYS_JOIN: {
                return 3;
            }
            case JOIN_IF_POSSIBLE: {
                return 4;
            }
            case NOT_SUPPORTED: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Unsupported action: " + action.name());
    }

    public static boolean isTransactional(ComponentModel operationModel) {
        return operationModel.getModelProperty(ConnectivityModelProperty.class).map(ConnectivityModelProperty::supportsTransactions).orElse(false);
    }

    public static ConfigurationFactory getConfigurationFactory(ConfigurationModel configurationModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)configurationModel, ConfigurationFactoryModelProperty.class, ConfigurationFactoryModelProperty::getConfigurationFactory, () -> new IllegalConfigurationModelDefinitionException(String.format("Configuration '%s' does not provide a %s", configurationModel.getName(), ConfigurationFactory.class.getName())));
    }

    public static MetadataResolverFactory getMetadataResolverFactory(EnrichableModel model) {
        return model.getModelProperty(MetadataResolverFactoryModelProperty.class).map(MetadataResolverFactoryModelProperty::getMetadataResolverFactory).orElse((MetadataResolverFactory)new NullMetadataResolverFactory());
    }

    public static OperationExecutorFactory getOperationExecutorFactory(OperationModel operationModel) {
        OperationExecutorFactory executorFactory = MuleExtensionUtils.fromModelProperty((EnrichableModel)operationModel, OperationExecutorModelProperty.class, OperationExecutorModelProperty::getExecutorFactory, () -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not provide a %s", operationModel.getName(), OperationExecutorFactory.class.getSimpleName())));
        return new OperationExecutorFactoryWrapper(executorFactory, MuleExtensionUtils.createInterceptors((EnrichableModel)operationModel));
    }

    public static SourceFactory getSourceFactory(SourceModel sourceModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)sourceModel, SourceFactoryModelProperty.class, SourceFactoryModelProperty::getSourceFactory, () -> new IllegalSourceModelDefinitionException(String.format("Source '%s' does not provide a %s", sourceModel.getName(), SourceFactory.class.getSimpleName())));
    }

    public static ConnectionProviderFactory getConnectionProviderFactory(ConnectionProviderModel connectionProviderModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)connectionProviderModel, ConnectionProviderFactoryModelProperty.class, ConnectionProviderFactoryModelProperty::getConnectionProviderFactory, () -> new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider '%s' does not provide a %s", connectionProviderModel.getName(), ConnectionProviderFactory.class.getSimpleName())));
    }

    public static Class<?> getConnectionType(ConnectionProviderModel connectionProviderModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)connectionProviderModel, ConnectionTypeModelProperty.class, ConnectionTypeModelProperty::getConnectionType, () -> new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider '%s' does not specify a connection type", connectionProviderModel.getName())));
    }

    private static <T, P extends ModelProperty> T fromModelProperty(EnrichableModel model, Class<P> modelPropertyType, Function<P, T> map, Supplier<? extends RuntimeException> exceptionSupplier) {
        return model.getModelProperty(modelPropertyType).map(map).orElseThrow(exceptionSupplier);
    }

    public static IllegalModelDefinitionException noClassLoaderException(String extensionName) {
        return new IllegalModelDefinitionException("No ClassLoader was specified for extension " + extensionName);
    }

    public static String getExtensionsErrorNamespace(ExtensionModel extensionModel) {
        return MuleExtensionUtils.getExtensionsErrorNamespace(extensionModel.getXmlDslModel());
    }

    public static String getExtensionsErrorNamespace(ExtensionDeclaration extensionDeclaration) {
        return MuleExtensionUtils.getExtensionsErrorNamespace(extensionDeclaration.getXmlDslModel());
    }

    private static String getExtensionsErrorNamespace(XmlDslModel dslModel) {
        return dslModel.getNamespace().toUpperCase();
    }

    private static class NamedObjectComparator
    implements Comparator<NamedObject> {
        private NamedObjectComparator() {
        }

        @Override
        public int compare(NamedObject o1, NamedObject o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

