/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transaction.TransactionException;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;

public final class TransactionalConnectionHandler<T extends TransactionalConnection>
implements ConnectionHandlerAdapter<T> {
    private final ExtensionTransactionalResource<T> resource;

    public TransactionalConnectionHandler(ExtensionTransactionalResource<T> resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (String)"resource cannot be null");
        this.resource = resource;
    }

    public T getConnection() throws ConnectionException {
        return this.resource.getConnection();
    }

    public void release() {
    }

    public synchronized void close() throws MuleException {
        ConnectionHandler<T> connectionHandler = this.resource.getConnectionHandler();
        Preconditions.checkArgument((boolean)(connectionHandler instanceof ConnectionHandlerAdapter), (String)"connectionHandlerAdapter was expected");
        if (!this.resource.isTransactionResolved()) {
            try {
                this.resource.rollback();
            }
            catch (Exception e) {
                throw new TransactionException((Throwable)e);
            }
        }
        ((ConnectionHandlerAdapter)connectionHandler).close();
    }
}

