/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MuleEvent;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionSourceExceptionCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;

final class ModuleFlowProcessingTemplate
implements ModuleFlowProcessingPhaseTemplate {
    private final Message message;
    private final Processor messageProcessor;
    private final SourceCompletionHandler completionHandler;
    private final MessageProcessContext messageProcessorContext;

    ModuleFlowProcessingTemplate(Message message, Processor messageProcessor, SourceCompletionHandler completionHandler, MessageProcessContext messageProcessContext) {
        this.message = message;
        this.messageProcessor = messageProcessor;
        this.completionHandler = completionHandler;
        this.messageProcessorContext = messageProcessContext;
    }

    public Function<Event, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return event -> this.completionHandler.createResponseParameters((Event)event);
    }

    public Function<Event, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return event -> this.completionHandler.createFailureResponseParameters((Event)event);
    }

    public Message getMessage() throws MuleException {
        return this.message;
    }

    public Event routeEvent(Event muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    public void sendResponseToClient(Event event, Map<String, Object> parameters, Function<Event, Map<String, Object>> errorResponseParametersFunction, ResponseCompletionCallback responseCompletionCallback) throws MuleException {
        Consumer<MessagingException> errorResponseCallback = messagingException -> this.completionHandler.onFailure((MessagingException)messagingException, (Map)errorResponseParametersFunction.apply(messagingException.getEvent()));
        ExtensionSourceExceptionCallback exceptionCallback = new ExtensionSourceExceptionCallback(responseCompletionCallback, event, errorResponseCallback, this.messageProcessorContext);
        this.runAndNotify(() -> this.completionHandler.onCompletion(event, parameters, exceptionCallback), (MuleEvent)event, responseCompletionCallback);
    }

    public void sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters, ResponseCompletionCallback responseCompletionCallback) throws MuleException {
        this.runAndNotify(() -> this.completionHandler.onFailure(messagingException, parameters), (MuleEvent)messagingException.getEvent(), responseCompletionCallback);
    }

    private void runAndNotify(Runnable runnable, MuleEvent event, ResponseCompletionCallback responseCompletionCallback) {
        try {
            runnable.run();
            responseCompletionCallback.responseSentSuccessfully();
        }
        catch (Exception e) {
            responseCompletionCallback.responseSentWithFailure(new MessagingException((Event)event, (Throwable)e), (Event)event);
        }
    }
}

