/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.function.Consumer;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ExceptionCallback;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.util.ExceptionUtils;

class ExtensionSourceExceptionCallback
implements ExceptionCallback {
    private final ResponseCompletionCallback completionCallback;
    private final Event event;
    private final Consumer<MessagingException> errorResponseHandler;
    private final MessageProcessContext messageProcessorContext;

    public ExtensionSourceExceptionCallback(ResponseCompletionCallback completionCallback, Event event, Consumer<MessagingException> errorResponseCallback, MessageProcessContext messageProcessContext) {
        this.completionCallback = completionCallback;
        this.event = event;
        this.errorResponseHandler = errorResponseCallback;
        this.messageProcessorContext = messageProcessContext;
    }

    public void onException(Throwable exception) {
        MessagingException messagingException = exception instanceof MessagingException ? (MessagingException)exception : new MessagingException(this.event, exception);
        Event errorEvent = ExceptionUtils.createErrorEvent((Event)this.event, (Object)this.messageProcessorContext.getMessageSource(), (MessagingException)messagingException, (ErrorTypeLocator)this.messageProcessorContext.getErrorTypeLocator());
        messagingException.setProcessedEvent(errorEvent);
        Event errorHandlingEvent = this.completionCallback.responseSentWithFailure(messagingException, errorEvent);
        messagingException.setProcessedEvent(errorHandlingEvent);
        this.errorResponseHandler.accept(messagingException);
    }
}

