/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.execution.ExceptionCallback;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessingManager;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionEnricherManager;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMessageSource
extends ExtensionComponent
implements MessageSource,
ExceptionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMessageSource.class);
    @Inject
    private MessageProcessingManager messageProcessingManager;
    @Inject
    private SchedulerService schdulerService;
    private final SourceModel sourceModel;
    private final SourceAdapterFactory sourceAdapterFactory;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final ExceptionEnricherManager exceptionEnricherManager;
    private Processor messageProcessor;
    private SourceAdapter sourceAdapter;
    private Scheduler retryScheduler;
    private Scheduler flowTriggerScheduler;

    public ExtensionMessageSource(ExtensionModel extensionModel, SourceModel sourceModel, SourceAdapterFactory sourceAdapterFactory, ConfigurationProvider configurationProvider, RetryPolicyTemplate retryPolicyTemplate, ExtensionManagerAdapter managerAdapter, ErrorTypeRepository errorTypeRepository) {
        super(extensionModel, (ComponentModel)sourceModel, configurationProvider, managerAdapter);
        this.sourceModel = sourceModel;
        this.sourceAdapterFactory = sourceAdapterFactory;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.exceptionEnricherManager = new ExceptionEnricherManager(extensionModel, (ComponentModel)sourceModel, errorTypeRepository);
    }

    private synchronized void createSource() throws Exception {
        if (this.sourceAdapter == null) {
            this.sourceAdapter = this.sourceAdapterFactory.createAdapter(this.getConfiguration(MuleExtensionUtils.getInitialiserEvent(this.muleContext)), this.createSourceCallbackFactory());
            this.muleContext.getInjector().inject((Object)this.sourceAdapter);
            this.sourceAdapter.setFlowConstruct(this.flowConstruct);
        }
    }

    private void startSource() {
        try {
            this.retryPolicyTemplate.execute((RetryCallback)new SourceRetryCallback(), (Executor)this.retryScheduler);
        }
        catch (Throwable e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void stopSource() throws MuleException {
        if (this.sourceAdapter != null) {
            try {
                this.sourceAdapter.stop();
            }
            catch (Exception e) {
                throw new DefaultMuleException(String.format("Found exception stopping source '%s' of flow '%s'", this.sourceAdapter.getName(), this.flowConstruct.getName()), (Throwable)e);
            }
        }
    }

    private SourceCallbackFactory createSourceCallbackFactory() {
        return completionHandlerFactory -> DefaultSourceCallback.builder().setConfigName(this.getConfigName()).setExceptionCallback(this).setFlowConstruct(this.flowConstruct).setListener(this.messageProcessor).setProcessingManager(this.messageProcessingManager).setProcessContextSupplier(this::createProcessingContext).setCompletionHandlerFactory(completionHandlerFactory).build();
    }

    public void onException(Throwable exception) {
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)(exception = this.exceptionEnricherManager.processException(exception)));
        if (connectionException.isPresent()) {
            try {
                LOGGER.warn(String.format("Message source '%s' on flow '%s' threw exception. Restarting...", this.sourceAdapter.getName(), this.flowConstruct.getName()), exception);
                this.restart();
            }
            catch (Throwable e) {
                this.notifyExceptionAndShutDown(e);
            }
        } else {
            this.notifyExceptionAndShutDown(exception);
        }
    }

    private void notifyExceptionAndShutDown(Throwable exception) {
        LOGGER.error(String.format("Message source '%s' on flow '%s' threw exception. Shutting down it forever...", this.sourceAdapter.getName(), this.flowConstruct.getName()), exception);
        this.shutdown();
    }

    private void restart() throws MuleException {
        this.stopSource();
        this.disposeSource();
        this.startSource();
    }

    @Override
    public void doStart() throws MuleException {
        if (this.retryScheduler == null) {
            this.retryScheduler = this.schdulerService.ioScheduler();
        }
        if (this.flowTriggerScheduler == null) {
            this.flowTriggerScheduler = this.schdulerService.cpuLightScheduler();
        }
        this.startSource();
    }

    @Override
    public void doStop() throws MuleException {
        try {
            this.stopSource();
        }
        finally {
            this.stopSchedulers();
        }
    }

    @Override
    public void doDispose() {
        this.disposeSource();
    }

    private void shutdown() {
        try {
            LifecycleUtils.stopIfNeeded((Object)((Object)this));
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to stop source '%s' on flow '%s'", this.sourceAdapter.getName(), this.flowConstruct.getName()), (Throwable)e);
        }
        LifecycleUtils.disposeIfNeeded((Object)((Object)this), (Logger)LOGGER);
    }

    private void stopSchedulers() {
        if (this.retryScheduler != null) {
            try {
                this.retryScheduler.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            finally {
                this.retryScheduler = null;
            }
        }
        if (this.flowTriggerScheduler != null) {
            try {
                this.flowTriggerScheduler.stop((long)this.muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS);
            }
            finally {
                this.flowTriggerScheduler = null;
            }
        }
    }

    private void disposeSource() {
        LifecycleUtils.disposeIfNeeded((Object)this.sourceAdapter, (Logger)LOGGER);
        this.sourceAdapter = null;
    }

    private MessageProcessContext createProcessingContext() {
        return new MessageProcessContext(){

            public boolean supportsAsynchronousProcessing() {
                return true;
            }

            public MessageSource getMessageSource() {
                return ExtensionMessageSource.this;
            }

            public FlowConstruct getFlowConstruct() {
                return ExtensionMessageSource.this.flowConstruct;
            }

            public Scheduler getFlowExecutionExecutor() {
                return ExtensionMessageSource.this.flowTriggerScheduler;
            }

            public TransactionConfig getTransactionConfig() {
                return null;
            }

            public ClassLoader getExecutionClassLoader() {
                return ExtensionMessageSource.this.muleContext.getExecutionClassLoader();
            }

            public ComponentIdentifier getSourceIdentifier() {
                return new ComponentIdentifier.Builder().withNamespace(ExtensionMessageSource.this.getExtensionModel().getName().toLowerCase()).withName(ExtensionMessageSource.this.sourceModel.getName()).build();
            }

            public ErrorTypeLocator getErrorTypeLocator() {
                return ExtensionMessageSource.this.muleContext.getErrorTypeLocator();
            }
        };
    }

    public void setListener(Processor listener) {
        this.messageProcessor = listener;
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getSourceModel(this.sourceModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getSourceModel(this.sourceModel.getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Flow '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.flowConstruct.getName(), this.sourceModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        return fieldName -> {
            try {
                return IntrospectionUtils.getFieldValue(this.sourceAdapter.getDelegate(), fieldName);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ValueResolvingException(e.getMessage(), e);
            }
        };
    }

    private String getConfigName() {
        ConfigurationProvider configurationProvider = this.getConfigurationProvider();
        return configurationProvider != null ? configurationProvider.getName() : null;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        try {
            this.createSource();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private class SourceRetryCallback
    implements RetryCallback {
        private SourceRetryCallback() {
        }

        public void doWork(RetryContext context) throws Exception {
            try {
                ExtensionMessageSource.this.createSource();
                ExtensionMessageSource.this.sourceAdapter.start();
            }
            catch (Exception e) {
                ExtensionMessageSource.this.stopSource();
                ExtensionMessageSource.this.disposeSource();
                Exception exception = ExtensionMessageSource.this.exceptionEnricherManager.processException(e);
                Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)exception);
                if (connectionException.isPresent()) {
                    exception = (Exception)connectionException.get();
                }
                throw exception;
            }
        }

        public String getWorkDescription() {
            return "Message Source Reconnection";
        }

        public Object getWorkOwner() {
            return ExtensionMessageSource.this;
        }
    }
}

