/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ValueHolder;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class NullSafeValueResolverWrapper<T>
implements ValueResolver<T> {
    private final ValueResolver<T> delegate;
    private final ValueResolver<T> fallback;

    public static <T> ValueResolver<T> of(ValueResolver<T> delegate, MetadataType type, final MuleContext muleContext) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        final ValueHolder value = new ValueHolder();
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                Class clazz = JavaTypeUtils.getType((MetadataType)objectType);
                String requiredFields = objectType.getFields().stream().filter(ObjectFieldType::isRequired).map(f -> f.getKey().getName().getLocalPart()).collect(Collectors.joining(", "));
                if (!StringUtils.isBlank((String)requiredFields)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Class '%s' cannot be used with '@%s' parameter since it contains non optional fields: [%s]", clazz.getName(), NullSafe.class.getSimpleName(), requiredFields));
                }
                ResolverSet resolverSet = new ResolverSet();
                for (Field field : IntrospectionUtils.getFields(clazz)) {
                    ValueResolver<Object> resolver = null;
                    ObjectFieldType objectField = objectType.getFieldByName(IntrospectionUtils.getAlias(field)).orElse(null);
                    if (objectField == null) continue;
                    Optional defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)objectField);
                    if (defaultValue.isPresent()) {
                        resolver = new TypeSafeExpressionValueResolver((String)defaultValue.get(), field.getType(), muleContext);
                    } else {
                        NullSafe nullSafe = field.getAnnotation(NullSafe.class);
                        if (nullSafe != null) {
                            Object nullSafeType = Object.class.equals((Object)nullSafe.defaultImplementingType()) ? objectField.getValue() : new BaseTypeBuilder(MetadataFormat.JAVA).objectType().with((TypeAnnotation)new TypeIdAnnotation(nullSafe.defaultImplementingType().getName())).build();
                            resolver = NullSafeValueResolverWrapper.of(new StaticValueResolver<Object>(null), nullSafeType, muleContext);
                        }
                    }
                    if (resolver == null) continue;
                    resolverSet.add(field.getName(), resolver);
                }
                DefaultResolverSetBasedObjectBuilder objectBuilder = new DefaultResolverSetBasedObjectBuilder(clazz, resolverSet);
                value.set(new ObjectBuilderValueResolver(objectBuilder));
            }

            public void visitArrayType(ArrayType arrayType) {
                Class collectionClass = JavaTypeUtils.getType((MetadataType)arrayType);
                value.set(CollectionValueResolver.of(collectionClass, Collections.emptyList()));
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                Class mapClass = JavaTypeUtils.getType((MetadataType)dictionaryType);
                value.set(MapValueResolver.of(mapClass, Collections.emptyList(), Collections.emptyList()));
            }

            protected void defaultVisit(MetadataType metadataType) {
                throw new IllegalParameterModelDefinitionException(String.format("Cannot use @%s on type '%s'", NullSafe.class.getSimpleName(), JavaTypeUtils.getType((MetadataType)metadataType)));
            }
        });
        return new NullSafeValueResolverWrapper<T>(delegate, (ValueResolver)value.get());
    }

    private NullSafeValueResolverWrapper(ValueResolver<T> delegate, ValueResolver<T> fallback) {
        this.delegate = delegate;
        this.fallback = fallback;
    }

    @Override
    public T resolve(Event event) throws MuleException {
        T value = this.delegate.resolve(event);
        if (value == null) {
            value = this.fallback.resolve(event);
        }
        return value;
    }

    @Override
    public boolean isDynamic() {
        return this.delegate.isDynamic();
    }
}

