/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ConnectionArgumentResolver
implements ArgumentResolver<Object> {
    @Override
    public Object resolve(ExecutionContext executionContext) {
        ConnectionHandler connectionHandler = (ConnectionHandler)((ExecutionContextAdapter)executionContext).getVariable("MULE_CONNECTION_PARAM");
        Preconditions.checkArgument((connectionHandler != null ? 1 : 0) != 0, (String)"No connection was provided for the operation");
        try {
            return connectionHandler.getConnection();
        }
        catch (ConnectionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Error was found trying to obtain a connection to execute %s '%s' of extension '%s'", IntrospectionUtils.getComponentModelTypeName(executionContext.getComponentModel()), executionContext.getComponentModel().getName(), executionContext.getExtensionModel().getName())), (Throwable)e);
        }
    }
}

