/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.runtime.api.message.Attributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.message.NullAttributes;
import org.mule.runtime.core.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;

    protected AbstractReturnDelegate(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        MediaType mediaType = this.resolveMediaType(value, operationContext);
        if (value instanceof Result) {
            return MuleExtensionUtils.toMessage((Result)value, mediaType);
        }
        return Message.builder().payload(value).mediaType(mediaType).attributes((Attributes)NullAttributes.NULL_ATTRIBUTES).build();
    }

    private MediaType resolveMediaType(Object value, ExecutionContextAdapter<ComponentModel> operationContext) {
        Optional optionalMediaType;
        Charset existingEncoding = SystemUtils.getDefaultEncoding((MuleContext)this.muleContext);
        MediaType mediaType = null;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = (MediaType)optionalMediaType.get()).getCharset().isPresent()) {
            existingEncoding = (Charset)mediaType.getCharset().get();
        }
        if (mediaType == null) {
            mediaType = MediaType.ANY;
        }
        if (operationContext.hasParameter("outputMimeType")) {
            mediaType = MediaType.parse((String)((String)operationContext.getTypeSafeParameter("outputMimeType", String.class)));
        }
        mediaType = operationContext.hasParameter("outputEncoding") ? mediaType.withCharset(Charset.forName((String)operationContext.getTypeSafeParameter("outputEncoding", String.class))) : mediaType.withCharset(existingEncoding);
        return mediaType;
    }
}

