/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import org.apache.commons.lang.ArrayUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.MethodArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ReflectiveMethodOperationExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectiveMethodComponentExecutor<M extends ComponentModel>
implements MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveMethodOperationExecutor.class);
    private static final ArgumentResolverDelegate NO_ARGS_DELEGATE = new NoArgumentsResolverDelegate();
    private final Method method;
    private final Object componentInstance;
    private final ArgumentResolverDelegate argumentResolverDelegate;
    private final ClassLoader extensionClassLoader;
    private MuleContext muleContext;

    public ReflectiveMethodComponentExecutor(M componentModel, Method method, Object componentInstance) {
        this.method = method;
        this.componentInstance = componentInstance;
        this.argumentResolverDelegate = ArrayUtils.isEmpty((Object[])method.getParameterTypes()) ? NO_ARGS_DELEGATE : new MethodArgumentResolverDelegate((ComponentModel)componentModel, method);
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
    }

    public Object execute(ExecutionContext<M> executionContext) throws Exception {
        return ClassUtils.withContextClassLoader((ClassLoader)this.extensionClassLoader, () -> ReflectionUtils.invokeMethod((Method)this.method, (Object)this.componentInstance, (Object[])this.getParameterValues(executionContext, this.method.getParameterTypes())));
    }

    private Object[] getParameterValues(ExecutionContext<M> executionContext, Class<?>[] parameterTypes) {
        return this.argumentResolverDelegate.resolve(executionContext, parameterTypes);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.componentInstance, (boolean)true, (MuleContext)this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentInstance);
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.componentInstance);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.componentInstance, (Logger)LOGGER);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.componentInstance instanceof MuleContextAware) {
            ((MuleContextAware)this.componentInstance).setMuleContext(context);
        }
    }

    private static class NoArgumentsResolverDelegate
    implements ArgumentResolverDelegate {
        private static final Object[] EMPTY = new Object[0];

        private NoArgumentsResolverDelegate() {
        }

        @Override
        public Object[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
            return EMPTY;
        }
    }
}

