/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.TypedException;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionEnricher;
import org.mule.runtime.module.extension.internal.model.property.ExceptionEnricherModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.NullExceptionEnricher;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ExceptionEnricherManager {
    private static final ExceptionEnricher DEFAULT_EXCEPTION_ENRICHER = new NullExceptionEnricher();
    private final ExceptionEnricher exceptionEnricher;
    private final ErrorTypeRepository typeRepository;
    private final String extensionNamespace;
    private final Set<ErrorModel> allowedErrorTypes;
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;

    public ExceptionEnricherManager(ExtensionModel extensionModel, ComponentModel componentModel, ErrorTypeRepository typeRepository) {
        this.typeRepository = typeRepository;
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.exceptionEnricher = this.findExceptionEnricher(extensionModel, (EnrichableModel)componentModel);
        this.allowedErrorTypes = componentModel.getErrorModels();
        this.extensionNamespace = MuleExtensionUtils.getExtensionsErrorNamespace(extensionModel);
    }

    public Exception processException(Throwable t) {
        Exception handledException = this.handleException(t);
        Exception exception = this.exceptionEnricher.enrichException(handledException);
        if (exception instanceof ModuleException) {
            ErrorTypeDefinition errorDefinition = ((ModuleException)exception).getType();
            exception = this.handleTypedException(exception, errorDefinition);
        }
        return exception != null ? exception : handledException;
    }

    private Exception handleTypedException(Exception exception, ErrorTypeDefinition errorDefinition) {
        Optional errorType;
        if (this.isAllowedError(errorDefinition)) {
            errorType = this.typeRepository.lookupErrorType(new ComponentIdentifier.Builder().withNamespace(this.extensionNamespace).withName(errorDefinition.getType()).build());
            if (!errorType.isPresent()) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The component '%s' from the connector '%s' attempted to throw '%s', but it was not registered in the Error Repository", (Object[])new Object[]{this.componentModel.getName(), this.extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition}), exception.getCause());
            }
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The component '%s' from the connector '%s' attempted to throw '%s', but only %s errors are allowed.", (Object[])new Object[]{this.componentModel.getName(), this.extensionModel.getName(), this.extensionNamespace + ":" + errorDefinition, this.allowedErrorTypes}), exception.getCause());
        }
        exception = new TypedException(exception.getCause(), (ErrorType)errorType.get());
        return exception;
    }

    public Exception handleException(Throwable e) {
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)e);
        Throwable handled = connectionException.isPresent() ? (Throwable)connectionException.get() : ExceptionUtils.extractCauseOfType((Throwable)e, UndeclaredThrowableException.class).orElse(e);
        return this.wrapInException(handled);
    }

    private Exception wrapInException(Throwable t) {
        return t instanceof Exception ? (Exception)t : new Exception(t);
    }

    private ExceptionEnricher findExceptionEnricher(ExtensionModel extension, EnrichableModel child) {
        return this.findExceptionEnricher(child).orElseGet(() -> this.findExceptionEnricher((EnrichableModel)extension).orElse(DEFAULT_EXCEPTION_ENRICHER));
    }

    private Optional<ExceptionEnricher> findExceptionEnricher(EnrichableModel model) {
        return model.getModelProperty(ExceptionEnricherModelProperty.class).map(p -> p.getExceptionEnricherFactory().createEnricher());
    }

    private boolean isAllowedError(ErrorTypeDefinition errorTypeDefinition) {
        return this.allowedErrorTypes.stream().anyMatch(errorModel -> errorModel.getType().equals(errorTypeDefinition.getType()) && errorModel.getNamespace().equals(this.extensionNamespace));
    }

    ExceptionEnricher getExceptionEnricher() {
        return this.exceptionEnricher;
    }
}

