/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionException;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionalConnectionHandler;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ExtensionsConnectionAdapter {
    @Inject
    private ConnectionManager connectionManager;

    public ConnectionHandler<?> getConnection(ExecutionContextAdapter<ComponentModel> executionContext) throws ConnectionException, TransactionException {
        return executionContext.getTransactionConfig().isPresent() ? this.getTransactedConnectionHandler(executionContext, executionContext.getTransactionConfig().get()) : this.getTransactionlessConnectionHandler(executionContext);
    }

    private <T> ConnectionHandler<T> getTransactionlessConnectionHandler(ExecutionContext executionContext) throws ConnectionException {
        Optional configuration = executionContext.getConfiguration();
        Optional<ConnectionProvider> connectionProvider = configuration.map(config -> config.getConnectionProvider()).map(Optional::get);
        if (!connectionProvider.isPresent()) {
            String configRef = configuration.map(config -> String.format("with config '%s' which is not associated to a connection provider", config.getName())).orElse("without a config");
            throw new IllegalStateException(String.format("%s '%s' of extension '%s' requires a connection but was executed %s", IntrospectionUtils.getComponentModelTypeName(executionContext.getComponentModel()), executionContext.getComponentModel().getName(), executionContext.getExtensionModel().getName(), configRef));
        }
        return this.connectionManager.getConnection(((ConfigurationInstance)configuration.get()).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends TransactionalConnection> ConnectionHandler<T> getTransactedConnectionHandler(ExecutionContextAdapter<ComponentModel> executionContext, TransactionConfig transactionConfig) throws ConnectionException, TransactionException {
        if (transactionConfig.getAction() == 7) {
            return this.getTransactionlessConnectionHandler(executionContext);
        }
        ConfigurationInstance configuration = (ConfigurationInstance)executionContext.getConfiguration().orElseThrow(() -> new IllegalStateException(String.format("Operation '%s' of extension '%s' cannot participate in a transaction because it doesn't have a config", executionContext.getComponentModel().getName(), executionContext.getExtensionModel().getName())));
        ExtensionTransactionKey txKey = new ExtensionTransactionKey(configuration);
        Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
        if (currentTx != null) {
            if (currentTx.hasResource((Object)txKey)) {
                return new TransactionalConnectionHandler((ExtensionTransactionalResource)currentTx.getResource((Object)txKey));
            }
            ConnectionHandler<T> connectionHandler = this.getTransactionlessConnectionHandler(executionContext);
            TransactionalConnection connection = (TransactionalConnection)connectionHandler.getConnection();
            ExtensionTransactionalResource<TransactionalConnection> txResource = this.createTransactionalResource(currentTx, connectionHandler, connection);
            boolean bound = false;
            try {
                if (currentTx.supports((Object)txKey, txResource)) {
                    currentTx.bindResource((Object)txKey, txResource);
                    bound = true;
                    TransactionalConnectionHandler<TransactionalConnection> transactionalConnectionHandler = new TransactionalConnectionHandler<TransactionalConnection>(txResource);
                    return transactionalConnectionHandler;
                }
                if (transactionConfig.isTransacted()) {
                    throw new TransactionException(I18nMessageFactory.createStaticMessage((String)String.format("%s '%s' of extension '%s' is transactional but current transaction doesn't support connections of type '%s'", IntrospectionUtils.getComponentModelTypeName(executionContext.getComponentModel()), executionContext.getComponentModel().getName(), executionContext.getExtensionModel().getName(), connectionHandler.getClass().getName())));
                }
            }
            finally {
                if (!bound) {
                    connectionHandler.release();
                }
            }
        }
        return this.getTransactionlessConnectionHandler(executionContext);
    }

    private <T extends TransactionalConnection> ExtensionTransactionalResource<T> createTransactionalResource(Transaction currentTx, ConnectionHandler<T> connectionHandler, T connection) {
        return connection instanceof XATransactionalConnection ? new XAExtensionTransactionalResource<XATransactionalConnection>((XATransactionalConnection)connection, connectionHandler, currentTx) : new ExtensionTransactionalResource<T>(connection, connectionHandler, currentTx);
    }
}

