/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transaction.TransactionException;
import org.mule.runtime.core.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.RetryRequest;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionsConnectionAdapter;

public final class ConnectionInterceptor
implements Interceptor {
    @Inject
    private ExtensionsConnectionAdapter connectionAdapter;

    public void before(ExecutionContext<OperationModel> executionContext) throws Exception {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        Preconditions.checkArgument((context.getVariable("MULE_CONNECTION_PARAM") == null ? 1 : 0) != 0, (String)"A connection was already set for this operation context");
        context.setVariable("MULE_CONNECTION_PARAM", this.getConnection(context));
    }

    public void after(ExecutionContext<OperationModel> executionContext, Object result) {
        ConnectionHandler connection = (ConnectionHandler)((ExecutionContextAdapter)executionContext).removeVariable("MULE_CONNECTION_PARAM");
        if (connection != null) {
            connection.release();
        }
    }

    public Throwable onError(ExecutionContext executionContext, RetryRequest retryRequest, Throwable exception) {
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)exception);
        if (connectionException.isPresent()) {
            retryRequest.request();
        }
        return exception;
    }

    private ConnectionHandler<?> getConnection(ExecutionContextAdapter operationContext) throws ConnectionException, TransactionException {
        return this.connectionAdapter.getConnection(operationContext);
    }
}

