/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.time.TimeSupplier;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.introspection.utils.ImplicitObjectUtils;
import org.mule.runtime.module.extension.internal.runtime.ImmutableExpirationPolicy;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderMetadataAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImplicitConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;

public final class DefaultImplicitConfigurationProviderFactory
implements ImplicitConfigurationProviderFactory {
    @Override
    public ConfigurationProvider createImplicitConfigurationProvider(ExtensionModel extensionModel, Event event, MuleContext muleContext) {
        ConfigurationModel implicitConfigurationModel = (ConfigurationModel)ImplicitObjectUtils.getFirstImplicit(extensionModel.getConfigurationModels());
        if (implicitConfigurationModel == null) {
            throw new IllegalStateException(String.format("Could not find a config for extension '%s' and none can be created automatically. Please define one", extensionModel.getName()));
        }
        String providerName = String.format("%s-%s", extensionModel.getName(), implicitConfigurationModel.getName());
        ResolverSet resolverSet = ImplicitObjectUtils.buildImplicitResolverSet((ParameterizedModel)implicitConfigurationModel, muleContext);
        try {
            ConfigurationInstance configurationInstance = new ConfigurationInstanceFactory(extensionModel, implicitConfigurationModel, resolverSet).createConfiguration(providerName, event, muleContext);
            String configName = configurationInstance.getName();
            ConfigurationModel configurationModel = configurationInstance.getModel();
            if (resolverSet.isDynamic()) {
                return new DynamicConfigurationProvider(configName, extensionModel, configurationModel, resolverSet, new ImplicitConnectionProviderValueResolver(configName, extensionModel, configurationModel, muleContext), ImmutableExpirationPolicy.getDefault(new TimeSupplier()));
            }
            return new ConfigurationProviderMetadataAdapter(configName, extensionModel, configurationModel, configurationInstance);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

