/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.PoolingConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConnectionProviderObjectBuilder
extends ResolverSetBasedObjectBuilder<ConnectionProvider> {
    private final ConnectionProviderModel providerModel;
    private final boolean disableValidation;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final PoolingProfile poolingProfile;
    private String ownerConfigName = "";

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ConnectionManagerAdapter connectionManager) {
        this(providerModel, resolverSet, null, false, null, connectionManager);
    }

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, boolean disableValidation, RetryPolicyTemplate retryPolicyTemplate, ConnectionManagerAdapter connectionManager) {
        super(MuleExtensionUtils.getConnectionProviderFactory(providerModel).getObjectType(), (ParameterizedModel)providerModel, resolverSet);
        this.providerModel = providerModel;
        this.poolingProfile = poolingProfile;
        this.retryPolicyTemplate = retryPolicyTemplate != null ? retryPolicyTemplate : connectionManager.getDefaultRetryPolicyTemplate();
        this.disableValidation = disableValidation;
    }

    @Override
    public ConnectionProvider build(ResolverSetResult result) throws MuleException {
        Object provider = (ConnectionProvider)super.build(result);
        MuleExtensionUtils.injectConfigName((EnrichableModel)this.providerModel, provider, this.ownerConfigName);
        ConnectionManagementType connectionManagementType = this.providerModel.getConnectionManagementType();
        provider = connectionManagementType == ConnectionManagementType.POOLING ? new PoolingConnectionProviderWrapper(provider, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate) : new ReconnectableConnectionProviderWrapper(provider, this.disableValidation, this.retryPolicyTemplate);
        return provider;
    }

    @Override
    protected ConnectionProvider instantiateObject() {
        return MuleExtensionUtils.getConnectionProviderFactory(this.providerModel).newInstance();
    }

    @Override
    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }

    public void setOwnerConfigName(String ownerConfigName) {
        this.ownerConfigName = ownerConfigName;
    }
}

