/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.MuleEvent;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataProvider;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.AbstractAnnotatedObject;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.TemplateParser;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.runtime.module.extension.internal.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.exception.TooManyConfigsException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtensionComponent
extends AbstractAnnotatedObject
implements MuleContextAware,
MetadataKeyProvider,
MetadataProvider,
FlowConstructAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionComponent.class);
    protected final ExtensionManagerAdapter extensionManager;
    private final TemplateParser expressionParser = TemplateParser.createMuleStyleParser();
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;
    private final ConfigurationProvider configurationProvider;
    private final MetadataMediator metadataMediator;
    private final ClassTypeLoader typeLoader;
    protected FlowConstruct flowConstruct;
    protected MuleContext muleContext;
    @Inject
    protected ConnectionManagerAdapter connectionManager;
    @Inject
    private MuleMetadataService metadataService;

    protected ExtensionComponent(ExtensionModel extensionModel, ComponentModel componentModel, ConfigurationProvider configurationProvider, ExtensionManagerAdapter extensionManager) {
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.configurationProvider = configurationProvider;
        this.extensionManager = extensionManager;
        this.metadataMediator = new MetadataMediator(componentModel);
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.getExtensionClassLoader());
    }

    public final void initialise() throws InitialisationException {
        ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
            this.validateConfigurationProviderIsNotExpression();
            Optional<ConfigurationProvider> provider = this.findConfigurationProvider();
            if (provider.isPresent()) {
                this.validateOperationConfiguration(provider.get());
            }
            this.doInitialise();
            return null;
        }, InitialisationException.class, e -> {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        });
    }

    public final void start() throws MuleException {
        ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
            this.doStart();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        });
    }

    public final void stop() throws MuleException {
        ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
            this.doStop();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        });
    }

    public final void dispose() {
        try {
            ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
                this.doDispose();
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Exception found trying to dispose component", (Throwable)e);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    protected abstract void doDispose();

    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        MetadataContext metadataContext = this.getMetadataContext();
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.metadataMediator.getMetadataKeys(metadataContext));
    }

    public MetadataResult<ComponentMetadataDescriptor> getMetadata() throws MetadataResolvingException {
        MetadataContext context = this.getMetadataContext();
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.metadataMediator.getMetadata(context, this.getParameterValueResolver()));
    }

    public MetadataResult<ComponentMetadataDescriptor> getMetadata(MetadataKey key) throws MetadataResolvingException {
        MetadataContext context = this.getMetadataContext();
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.metadataMediator.getMetadata(context, key));
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    protected MetadataContext getMetadataContext() throws MetadataResolvingException {
        ConfigurationProvider configurationProvider;
        Event fakeEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        Optional<ConfigurationInstance> configuration = this.getConfiguration(fakeEvent);
        if (configuration.isPresent() && (configurationProvider = this.findConfigurationProvider().orElseThrow(() -> new MetadataResolvingException("Failed to create the required configuration for Metadata retrieval", FailureCode.INVALID_CONFIGURATION))) instanceof DynamicConfigurationProvider) {
            throw new MetadataResolvingException("Configuration used for Metadata fetch cannot be dynamic", FailureCode.INVALID_CONFIGURATION);
        }
        String cacheId = configuration.map(ConfigurationInstance::getName).orElseGet(() -> this.extensionModel.getName() + "|" + this.componentModel.getName());
        return new DefaultMetadataContext(configuration, (ConnectionManager)this.connectionManager, this.metadataService.getMetadataCache(cacheId), this.typeLoader);
    }

    protected Optional<ConfigurationInstance> getConfiguration(Event event) {
        if (!ExtensionModelUtils.requiresConfig((NamedObject)this.componentModel)) {
            return Optional.empty();
        }
        if (this.isConfigurationSpecified()) {
            return this.findConfigurationProvider().map(provider -> Optional.of(provider.get((Object)event))).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Flow '%s' contains a reference to config '%s' but it doesn't exists", this.flowConstruct.getName(), this.configurationProvider)));
        }
        return Optional.of(this.getConfigurationProviderByModel().map(provider -> provider.get((Object)event)).orElseGet(() -> this.extensionManager.getConfiguration(this.extensionModel, (MuleEvent)event)));
    }

    protected ClassLoader getExtensionClassLoader() {
        return MuleExtensionUtils.getClassLoader(this.extensionModel);
    }

    private Optional<ConfigurationProvider> findConfigurationProvider() {
        if (ExtensionModelUtils.requiresConfig((NamedObject)this.componentModel)) {
            return this.isConfigurationSpecified() ? Optional.of(this.configurationProvider) : this.getConfigurationProviderByModel();
        }
        return Optional.empty();
    }

    private Optional<ConfigurationProvider> getConfigurationProviderByModel() {
        try {
            return this.extensionManager.getConfigurationProvider(this.extensionModel);
        }
        catch (TooManyConfigsException e) {
            throw new IllegalStateException(String.format("No config-ref was specified for component '%s' of extension '%s', but %d are registered. Please specify which to use", this.componentModel.getName(), this.extensionModel.getName(), e.getConfigsCount()), (Throwable)((Object)e));
        }
    }

    private boolean isConfigurationSpecified() {
        return this.configurationProvider != null;
    }

    private void validateConfigurationProviderIsNotExpression() throws InitialisationException {
        if (this.isConfigurationSpecified() && this.expressionParser.isContainsTemplate(this.configurationProvider.getName())) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("Flow '%s' defines component '%s' which specifies the expression '%s' as a config-ref. Expressions are not allowed as config references", this.flowConstruct.getName(), NameUtils.hyphenize((String)this.componentModel.getName()), this.configurationProvider)), (Initialisable)this);
        }
    }

    protected ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected abstract ParameterValueResolver getParameterValueResolver();

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }
}

