/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultExecutionContext<M extends ComponentModel>
implements ExecutionContextAdapter<M> {
    private static final ExtensionTransactionFactory TRANSACTION_FACTORY = new ExtensionTransactionFactory();
    private final ExtensionModel extensionModel;
    private final Optional<ConfigurationInstance> configuration;
    private final Map<String, Object> parameters;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final M componentModel;
    private final MuleContext muleContext;
    private Event event;
    private Optional<TransactionConfig> transactionConfig = null;
    private Supplier<Optional<TransactionConfig>> transactionConfigSupplier;

    public DefaultExecutionContext(ExtensionModel extensionModel, Optional<ConfigurationInstance> configuration, Map<String, Object> parameters, M componentModel, Event event, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.configuration = configuration;
        this.event = event;
        this.componentModel = componentModel;
        this.parameters = parameters;
        this.muleContext = muleContext;
        this.transactionConfigSupplier = () -> {
            DefaultExecutionContext defaultExecutionContext = this;
            synchronized (defaultExecutionContext) {
                if (this.transactionConfig == null) {
                    this.transactionConfig = MuleExtensionUtils.isTransactional(componentModel) ? Optional.of(this.buildTransactionConfig()) : Optional.empty();
                    this.transactionConfigSupplier = () -> this.transactionConfig;
                }
                return this.transactionConfig;
            }
        };
    }

    public Optional<ConfigurationInstance> getConfiguration() {
        return this.configuration;
    }

    public boolean hasParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public <T> T getParameter(String parameterName) {
        if (this.hasParameter(parameterName)) {
            return (T)this.parameters.get(parameterName);
        }
        throw new NoSuchElementException(parameterName);
    }

    public <T> T getTypeSafeParameter(String parameterName, Class<? extends T> expectedType) {
        T value = this.getParameter(parameterName);
        if (value == null) {
            return null;
        }
        if (!expectedType.isInstance(value)) {
            throw new IllegalArgumentException(String.format("'%s' was expected to be of type '%s' but type '%s' was found instead", parameterName, expectedType.getName(), value.getClass().getName()));
        }
        return value;
    }

    @Override
    public <T> T getVariable(String key) {
        return (T)this.variables.get(key);
    }

    @Override
    public Object setVariable(String key, Object value) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"null keys are not allowed");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"null values are not allowed");
        return this.variables.put(key, value);
    }

    @Override
    public <T> T removeVariable(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"null keys are not allowed");
        return (T)this.variables.remove(key);
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    public M getComponentModel() {
        return this.componentModel;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public Optional<TransactionConfig> getTransactionConfig() {
        return this.transactionConfigSupplier.get();
    }

    private TransactionConfig buildTransactionConfig() {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.getTransactionalAction()));
        transactionConfig.setMuleContext(this.muleContext);
        transactionConfig.setFactory((TransactionFactory)TRANSACTION_FACTORY);
        return transactionConfig;
    }

    private OperationTransactionalAction getTransactionalAction() {
        OperationTransactionalAction action = this.getTypeSafeParameter("transactionalAction", OperationTransactionalAction.class);
        if (action == null) {
            throw new IllegalArgumentException(String.format("Operation '%s' from extension '%s' is transactional but no transactional action defined", this.componentModel.getName(), this.extensionModel.getName()));
        }
        return action;
    }
}

