/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.builder.MetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;

class MetadataOutputDelegate
extends BaseMetadataDelegate {
    public MetadataOutputDelegate(ComponentModel componentModel) {
        super(componentModel);
    }

    MetadataResult<OutputMetadataDescriptor> getOutputMetadataDescriptor(MetadataContext context, Object key) {
        MetadataResult<MetadataType> outputMetadataResult = this.getOutputMetadata(context, key);
        MetadataResult<MetadataType> attributesMetadataResult = this.getOutputAttributesMetadata(context, key);
        MetadataResult<TypeMetadataDescriptor> outputDescriptor = this.toMetadataDescriptorResult(this.component.getOutput().getType(), this.component.getOutput().hasDynamicType(), outputMetadataResult);
        MetadataResult<TypeMetadataDescriptor> attributesDescriptor = this.toMetadataDescriptorResult(this.component.getOutputAttributes().getType(), false, attributesMetadataResult);
        OutputMetadataDescriptor descriptor = MetadataDescriptorBuilder.outputDescriptor().withReturnType(outputDescriptor).withAttributesType(attributesDescriptor).build();
        if (!outputMetadataResult.isSuccess() || !attributesMetadataResult.isSuccess()) {
            return this.mergeFailures(descriptor, outputMetadataResult, attributesMetadataResult);
        }
        return MetadataResult.success((Object)descriptor);
    }

    private MetadataResult<MetadataType> getOutputMetadata(MetadataContext context, Object key) {
        OutputModel output = this.component.getOutput();
        if (MetadataTypeUtils.isVoid((MetadataType)output.getType()) || !output.hasDynamicType()) {
            return MetadataResult.success((Object)output.getType());
        }
        return this.resolveMetadataType(false, output.getType(), () -> this.resolverFactory.getOutputResolver().getOutputType(context, key), "Output");
    }

    private MetadataResult<MetadataType> getOutputAttributesMetadata(MetadataContext context, Object key) {
        OutputModel attributes = this.component.getOutputAttributes();
        if (MetadataTypeUtils.isVoid((MetadataType)attributes.getType()) || !attributes.hasDynamicType()) {
            return MetadataResult.success((Object)attributes.getType());
        }
        return this.resolveMetadataType(false, attributes.getType(), () -> this.resolverFactory.getOutputAttributesResolver().getAttributesType(context, key), "OutputAttributes");
    }

    private MetadataResult<TypeMetadataDescriptor> toMetadataDescriptorResult(MetadataType type, boolean isDynamic, MetadataResult<MetadataType> result) {
        MetadataType resultingType = result.get() == null ? type : (MetadataType)result.get();
        TypeMetadataDescriptor descriptor = MetadataDescriptorBuilder.typeDescriptor().withType(resultingType).dynamic(isDynamic).build();
        if (result.isSuccess()) {
            return MetadataResult.success((Object)descriptor);
        }
        MetadataFailure failure = (MetadataFailure)result.getFailure().get();
        return MetadataResult.failure((Object)descriptor, (String)failure.getMessage(), (FailureCode)failure.getFailureCode(), (String)failure.getReason());
    }
}

