/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.builder.MetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.model.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.model.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataInputDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeyIdObjectResolver;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeysDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataOutputDelegate;
import org.mule.runtime.module.extension.internal.runtime.ParameterValueResolver;

public class MetadataMediator {
    private final ComponentModel component;
    private final List<ParameterModel> metadataKeyParts;
    private final MetadataKeysDelegate keysDelegate;
    private final MetadataOutputDelegate outputDelegate;
    private final MetadataInputDelegate inputDelegate;
    private final MetadataKeyIdObjectResolver keyIdObjectResolver;
    private String keyContainerName = null;

    public MetadataMediator(ComponentModel componentModel) {
        this.component = componentModel;
        this.metadataKeyParts = this.getMetadataKeyParts(componentModel);
        this.keysDelegate = new MetadataKeysDelegate(componentModel, this.metadataKeyParts);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.component);
        this.outputDelegate = new MetadataOutputDelegate(componentModel);
        this.inputDelegate = new MetadataInputDelegate(componentModel);
        Optional optionalKeyIdModelProperty = componentModel.getModelProperty(MetadataKeyIdModelProperty.class);
        if (optionalKeyIdModelProperty.isPresent()) {
            this.keyContainerName = ((MetadataKeyIdModelProperty)optionalKeyIdModelProperty.get()).getParameterName();
        }
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context) {
        return this.keysDelegate.getMetadataKeys(context);
    }

    public MetadataResult<ComponentMetadataDescriptor> getMetadata(MetadataContext context, MetadataKey key) {
        try {
            Object resolvedKey = this.keyIdObjectResolver.resolve(key);
            return this.getMetadata(context, (String p) -> resolvedKey);
        }
        catch (MetadataResolvingException e) {
            return MetadataResult.failure((Exception)((Object)e), (FailureCode)e.getFailure());
        }
    }

    public MetadataResult<ComponentMetadataDescriptor> getMetadata(MetadataContext context, ParameterValueResolver metadataKeyResolver) {
        MetadataResult<Object> keyValueResult = this.getMetadataKeyObjectValue(metadataKeyResolver);
        if (!keyValueResult.isSuccess()) {
            return keyValueResult;
        }
        Object keyValue = keyValueResult.get();
        MetadataResult<OutputMetadataDescriptor> output = this.outputDelegate.getOutputMetadataDescriptor(context, keyValue);
        MetadataResult<InputMetadataDescriptor> input = this.inputDelegate.getInputMetadataDescriptors(context, keyValue);
        ComponentMetadataDescriptor componentDescriptor = MetadataDescriptorBuilder.componentDescriptor((String)this.component.getName()).withInputDescriptor(input).withOutputDescriptor(output).build();
        return MetadataResult.mergeResults((Object)componentDescriptor, (MetadataResult[])new MetadataResult[]{output, input});
    }

    private MetadataResult<Object> getMetadataKeyObjectValue(ParameterValueResolver metadataKeyResolver) {
        try {
            Object keyValue = this.getContainerName().isPresent() ? metadataKeyResolver.getParameterValue(this.getContainerName().get()) : null;
            return MetadataResult.success(keyValue);
        }
        catch (Exception e) {
            return MetadataResult.failure((Exception)e);
        }
    }

    private List<ParameterModel> getMetadataKeyParts(ComponentModel componentModel) {
        return componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    private Optional<String> getContainerName() {
        return Optional.ofNullable(this.keyContainerName);
    }
}

