/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.extension.api.model.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;
import org.mule.runtime.module.extension.internal.metadata.PartAwareMetadataKeyBuilder;

class MetadataKeysDelegate
extends BaseMetadataDelegate {
    private static final int INITIAL_PART_LEVEL = 1;
    private final List<ParameterModel> keyParts;

    public MetadataKeysDelegate(ComponentModel componentModel, List<ParameterModel> metadataKeyParts) {
        super(componentModel);
        this.keyParts = metadataKeyParts;
    }

    MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataContext context) {
        TypeKeysResolver keyResolver = this.resolverFactory.getKeyResolver();
        String componentResolverName = keyResolver.getCategoryName();
        MetadataKeysContainerBuilder keysContainer = MetadataKeysContainerBuilder.getInstance();
        if (this.keyParts.isEmpty()) {
            return MetadataResult.success((Object)keysContainer.add(componentResolverName, (Set)ImmutableSet.of((Object)new NullMetadataKey())).build());
        }
        try {
            Set metadataKeys = keyResolver.getKeys(context);
            Map<Integer, String> partOrder = this.getPartOrderMapping(this.keyParts);
            Set enrichedMetadataKeys = metadataKeys.stream().map(metadataKey -> this.cloneAndEnrichMetadataKey((MetadataKey)metadataKey, partOrder)).map(MetadataKeyBuilder::build).collect(Collectors.toSet());
            keysContainer.add(componentResolverName, enrichedMetadataKeys);
            return MetadataResult.success((Object)keysContainer.build());
        }
        catch (Exception e) {
            return MetadataResult.failure((Exception)e);
        }
    }

    private Map<Integer, String> getPartOrderMapping(List<ParameterModel> parameterModels) {
        return parameterModels.stream().filter(this::isKeyPart).collect(Collectors.toMap(part -> ((MetadataKeyPartModelProperty)part.getModelProperty(MetadataKeyPartModelProperty.class).get()).getOrder(), NamedObject::getName));
    }

    private boolean isKeyPart(ParameterModel part) {
        return part.getModelProperty(MetadataKeyPartModelProperty.class).isPresent();
    }

    private MetadataKeyBuilder cloneAndEnrichMetadataKey(MetadataKey key, Map<Integer, String> partOrderMapping) {
        return this.cloneAndEnrichMetadataKey(key, partOrderMapping, 1);
    }

    private MetadataKeyBuilder cloneAndEnrichMetadataKey(MetadataKey key, Map<Integer, String> partOrderMapping, int level) {
        MetadataKeyBuilder keyBuilder = PartAwareMetadataKeyBuilder.newKey(key.getId(), partOrderMapping.get(level)).withDisplayName(key.getDisplayName());
        key.getProperties().forEach(arg_0 -> ((MetadataKeyBuilder)keyBuilder).withProperty(arg_0));
        key.getChilds().forEach(childKey -> keyBuilder.withChild(this.cloneAndEnrichMetadataKey((MetadataKey)childKey, partOrderMapping, level + 1)));
        return keyBuilder;
    }
}

