/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.LinkedList;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.builder.InputMetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.descriptor.builder.MetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.descriptor.builder.ParameterMetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;

class MetadataInputDelegate
extends BaseMetadataDelegate {
    MetadataInputDelegate(ComponentModel componentModel) {
        super(componentModel);
    }

    MetadataResult<InputMetadataDescriptor> getInputMetadataDescriptors(MetadataContext context, Object key) {
        InputMetadataDescriptorBuilder input = MetadataDescriptorBuilder.inputDescriptor();
        LinkedList<MetadataResult<ParameterMetadataDescriptor>> results = new LinkedList<MetadataResult<ParameterMetadataDescriptor>>();
        for (ParameterModel parameter : this.component.getAllParameterModels()) {
            MetadataResult<ParameterMetadataDescriptor> result = this.getParameterMetadataDescriptor(parameter, context, key);
            input.withParameter(parameter.getName(), result);
            results.add(result);
        }
        if (results.isEmpty()) {
            return MetadataResult.success((Object)input.build());
        }
        return MetadataResult.mergeResults((Object)input.build(), (MetadataResult[])results.toArray(new MetadataResult[0]));
    }

    private MetadataResult<ParameterMetadataDescriptor> getParameterMetadataDescriptor(ParameterModel parameter, MetadataContext context, Object key) {
        ParameterMetadataDescriptorBuilder descriptorBuilder = MetadataDescriptorBuilder.parameterDescriptor((String)parameter.getName());
        if (!parameter.hasDynamicType()) {
            return MetadataResult.success((Object)descriptorBuilder.withType(parameter.getType()).build());
        }
        descriptorBuilder.dynamic(true);
        MetadataResult<MetadataType> inputMetadataResult = this.getParameterMetadata(parameter, context, key);
        MetadataType type = inputMetadataResult.get() == null ? parameter.getType() : (MetadataType)inputMetadataResult.get();
        ParameterMetadataDescriptor descriptor = descriptorBuilder.withType(type).build();
        return inputMetadataResult.isSuccess() ? MetadataResult.success((Object)descriptor) : MetadataResult.failure((Object)descriptor, inputMetadataResult);
    }

    private MetadataResult<MetadataType> getParameterMetadata(ParameterModel parameter, MetadataContext context, Object key) {
        boolean allowsNullType = !parameter.isRequired() && parameter.getDefaultValue() == null;
        return this.resolveMetadataType(allowsNullType, parameter.getType(), () -> this.resolverFactory.getInputResolver(parameter.getName()).getInputMetadata(context, key), parameter.getName());
    }
}

