/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.builder.MetadataDescriptorBuilder;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.QueryEntityResolver;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class EntityMetadataMediator {
    private final MetadataResolverFactory resolverFactory;

    public EntityMetadataMediator(OperationModel operationModel) {
        this.resolverFactory = MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)operationModel);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(MetadataContext context) {
        try {
            QueryEntityResolver queryEntityResolver = this.resolverFactory.getQueryEntityResolver();
            Set entityKeys = queryEntityResolver.getEntityKeys(context);
            MetadataKeysContainerBuilder keyBuilder = MetadataKeysContainerBuilder.getInstance();
            if (entityKeys.stream().anyMatch(key -> key.getChilds().size() > 0)) {
                throw new IllegalArgumentException("Entity keys must not contain childs. Only single level keys are supported for Entity Metadata Retrieval");
            }
            return MetadataResult.success((Object)keyBuilder.add(queryEntityResolver.getClass().getSimpleName(), entityKeys).build());
        }
        catch (Exception e) {
            return MetadataResult.failure((Exception)e);
        }
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataContext context, MetadataKey entityKey) {
        try {
            MetadataType entityMetadata = this.resolverFactory.getQueryEntityResolver().getEntityMetadata(context, entityKey.getId());
            return MetadataResult.success((Object)MetadataDescriptorBuilder.typeDescriptor().withType(entityMetadata).build());
        }
        catch (Exception e) {
            return MetadataResult.failure((Exception)e);
        }
    }
}

