/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class BaseMetadataDelegate {
    protected final ComponentModel component;
    protected final MetadataResolverFactory resolverFactory;

    BaseMetadataDelegate(ComponentModel component) {
        this.component = component;
        this.resolverFactory = MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)component);
    }

    protected MetadataResult<MetadataType> resolveMetadataType(boolean allowsNullType, MetadataType staticType, MetadataDelegate delegate, String elementName) {
        try {
            MetadataType dynamicType = delegate.resolve();
            if (dynamicType == null || MetadataTypeUtils.isVoid((MetadataType)dynamicType) && !allowsNullType) {
                return MetadataResult.failure((Object)staticType, (String)String.format("An error occurred while resolving the MetadataType of the [%s]", elementName), (FailureCode)FailureCode.NO_DYNAMIC_TYPE_AVAILABLE, (String)"The resulting MetadataType was of NullType, but it is not a valid type for this element");
            }
            return MetadataResult.success((Object)dynamicType);
        }
        catch (Exception e) {
            return MetadataResult.failure((Object)staticType, (Exception)e);
        }
    }

    protected <T> MetadataResult<T> mergeFailures(T descriptor, MetadataResult<?> ... results) {
        List failedResults = Stream.of(results).filter(result -> !result.isSuccess()).collect(Collectors.toList());
        String messages = failedResults.stream().map(f -> ((MetadataFailure)f.getFailure().get()).getMessage()).collect(Collectors.joining(" and "));
        String stackTrace = failedResults.size() == 1 ? ((MetadataFailure)((MetadataResult)failedResults.get(0)).getFailure().get()).getReason() : "";
        FailureCode failureCode = failedResults.size() == 1 ? ((MetadataFailure)((MetadataResult)failedResults.get(0)).getFailure().get()).getFailureCode() : FailureCode.MULTIPLE;
        return MetadataResult.failure(descriptor, (String)messages, (FailureCode)failureCode, (String)stackTrace);
    }

    @FunctionalInterface
    protected static interface MetadataDelegate {
        public MetadataType resolve() throws MetadataResolvingException, ConnectionException;
    }
}

