/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.spi.Describer;
import org.mule.runtime.extension.api.manifest.ExtensionManifest;
import org.mule.runtime.module.extension.internal.introspection.describer.AnnotationsBasedDescriber;
import org.mule.runtime.module.extension.internal.introspection.version.StaticVersionResolver;

final class DescriberResolver {
    private final Map<String, DescriberResolverDelegate> delegates = ImmutableMap.builder().put((Object)"annotations", (Object)this.createAnnotationDescriberDelegate()).build();

    DescriberResolver() {
    }

    Describer resolve(ExtensionManifest manifest, ClassLoader classLoader) {
        DescriberResolverDelegate delegate = this.delegates.get(manifest.getDescriberManifest().getId());
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Manifest for extension '%s' references describer '%s' which is not supported", manifest.getName(), manifest.getDescriberManifest().getId()));
        }
        return delegate.resolve(manifest, classLoader);
    }

    private DescriberResolverDelegate createAnnotationDescriberDelegate() {
        return (manifest, classLoader) -> {
            Class extensionType;
            String type = (String)manifest.getDescriberManifest().getProperties().get("type");
            if (StringUtils.isBlank((CharSequence)type)) {
                throw new IllegalArgumentException(String.format("Manifest for extension '%s' has no '%s' property", manifest.getName(), "type"));
            }
            try {
                extensionType = ClassUtils.loadClass((String)type, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Class '%s' cannot be loaded for extension '%s'", type, manifest.getName()), e);
            }
            return new AnnotationsBasedDescriber(extensionType, new StaticVersionResolver(manifest.getVersion()));
        };
    }

    @FunctionalInterface
    private static interface DescriberResolverDelegate {
        public Describer resolve(ExtensionManifest var1, ClassLoader var2);
    }
}

