/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.util.ExtensionMetadataTypeUtils;

public final class SubtypesModelValidator
implements ModelValidator {
    @Override
    public void validate(ExtensionModel model) throws IllegalModelDefinitionException {
        Map typesMapping = ExtensionModelUtils.toSubTypesMap((Collection)model.getSubTypes());
        this.validateBaseTypeNotFinal(model, typesMapping);
        this.validateNonAbstractSubtypes(model, typesMapping);
        this.validateSubtypesExtendOrImplementBaseType(model, typesMapping);
        this.validateSubtypesNameClashing(model, typesMapping);
    }

    private void validateBaseTypeNotFinal(ExtensionModel model, Map<MetadataType, Set<MetadataType>> typesMapping) {
        List finalBaseTypes = typesMapping.keySet().stream().filter(ExtensionMetadataTypeUtils::isFinal).map(ExtensionMetadataTypeUtils::getId).collect(Collectors.toList());
        if (!finalBaseTypes.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("All the declared SubtypesMapping in extension %s should have non final base types, but [%s] are final", model.getName(), Arrays.toString(finalBaseTypes.toArray())));
        }
    }

    private void validateNonAbstractSubtypes(ExtensionModel model, Map<MetadataType, Set<MetadataType>> typesMapping) {
        LinkedList abstractSubtypes = new LinkedList();
        for (Set<MetadataType> subtypes : typesMapping.values()) {
            abstractSubtypes.addAll(subtypes.stream().filter(s -> !ExtensionMetadataTypeUtils.isInstantiable(s)).map(ExtensionMetadataTypeUtils::getId).collect(Collectors.toList()));
        }
        if (!abstractSubtypes.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("All the declared Subtypes in extension %s should be of concrete types, but [%s] are non instantiable", model.getName(), Arrays.toString(abstractSubtypes.toArray())));
        }
    }

    private void validateSubtypesExtendOrImplementBaseType(ExtensionModel model, Map<MetadataType, Set<MetadataType>> typesMapping) {
        for (Map.Entry<MetadataType, Set<MetadataType>> subtypes : typesMapping.entrySet()) {
            if (!subtypes.getKey().getMetadataFormat().equals((Object)MetadataFormat.JAVA)) continue;
            Class baseType = JavaTypeUtils.getType((MetadataType)subtypes.getKey());
            List invalidTypes = subtypes.getValue().stream().map(JavaTypeUtils::getType).filter(s -> !baseType.isAssignableFrom((Class<?>)s)).map(Class::getSimpleName).collect(Collectors.toList());
            if (invalidTypes.isEmpty()) continue;
            throw new IllegalModelDefinitionException(String.format("All the declared Subtypes in extension %s should be concrete implementations of the give baseType, but [%s] are not implementations of [%s]", model.getName(), Arrays.toString(invalidTypes.toArray()), baseType.getSimpleName()));
        }
    }

    private void validateSubtypesNameClashing(ExtensionModel model, Map<MetadataType, Set<MetadataType>> typesMapping) {
        ImmutableList mappedTypes = ImmutableList.builder().addAll(typesMapping.keySet()).addAll((Iterable)typesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList())).build();
        HashMap<String, MetadataType> typesByName = new HashMap<String, MetadataType>();
        for (MetadataType type : mappedTypes) {
            MetadataType previousType = typesByName.put(NameUtils.getTopLevelTypeName((MetadataType)type), type);
            if (previousType == null || previousType.equals(type)) continue;
            throw new IllegalModelDefinitionException(String.format("Subtypes mapped Type [%s] with alias [%s] in extension [%s] should have a different alias name than the previous mapped type [%s]", ExtensionMetadataTypeUtils.getAlias(type), NameUtils.getTopLevelTypeName((MetadataType)type), model.getName(), ExtensionMetadataTypeUtils.getAlias(previousType)));
        }
    }
}

