/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;

public final class OperationParametersModelValidator
implements ModelValidator {
    private final List<String> reservedWords = ImmutableList.of((Object)"target");

    @Override
    public void validate(ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        LinkedHashMultimap offenses = LinkedHashMultimap.create();
        new IdempotentExtensionWalker((Multimap)offenses){
            final /* synthetic */ Multimap val$offenses;
            {
                this.val$offenses = multimap;
            }

            protected void onOperation(OperationModel model) {
                OperationParametersModelValidator.this.collectOffenses((Multimap<String, String>)this.val$offenses, model);
            }
        }.walk(extensionModel);
        if (!offenses.isEmpty()) {
            StringBuilder message = new StringBuilder(String.format("Extension '%s' defines operations which have parameters named after reserved words. Offending operations are:\n", extensionModel.getName()));
            offenses.asMap().forEach((key, values) -> message.append(String.format("%s: [%s]", key, Joiner.on((String)", ").join((Iterable)values))));
            throw new IllegalOperationModelDefinitionException(message.toString());
        }
    }

    private void collectOffenses(Multimap<String, String> offenses, OperationModel operationModel) {
        operationModel.getAllParameterModels().stream().filter(parameter -> this.reservedWords.contains(parameter.getName())).forEach(parameter -> offenses.put((Object)parameter.getName(), (Object)operationModel.getName()));
    }
}

