/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ExclusiveParameterModelValidator
implements ModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        new ExtensionWalker(){

            public void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                model.getExclusiveParametersModels().forEach(exclusiveParametersModel -> {
                    Set exclusiveParameterNames = exclusiveParametersModel.getExclusiveParameterNames();
                    if (exclusiveParameterNames.isEmpty()) {
                        throw new IllegalParameterModelDefinitionException(String.format("In %s '%s', parameter group '%s' defines an empty set of exclusive parameters", IntrospectionUtils.getComponentModelTypeName(owner), IntrospectionUtils.getModelName(owner), model.getName()));
                    }
                    List optionalParameters = model.getParameterModels().stream().filter(p -> exclusiveParameterNames.contains(p.getName())).collect(Collectors.toList());
                    if (optionalParameters.size() < 2) {
                        throw new IllegalParameterModelDefinitionException(String.format("In %s '%s', parameter group '%s' defines exclusive optional parameters, and thus should contain more than one parameter marked as optional but %d was/were found", IntrospectionUtils.getComponentModelTypeName(owner), IntrospectionUtils.getModelName(owner), model.getName(), optionalParameters.size()));
                    }
                });
            }
        }.walk(extensionModel);
    }
}

