/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ContentParameterModelValidator
implements ModelValidator {
    @Override
    public void validate(final ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        new IdempotentExtensionWalker(){

            public void onConfiguration(ConfigurationModel model) {
                ContentParameterModelValidator.this.validateNoContent(extensionModel, (ParameterizedModel)model);
            }

            protected void onConnectionProvider(ConnectionProviderModel model) {
                ContentParameterModelValidator.this.validateNoContent(extensionModel, (ParameterizedModel)model);
            }

            protected void onOperation(OperationModel model) {
                ContentParameterModelValidator.this.validateContent(extensionModel, (ParameterizedModel)model);
            }

            protected void onSource(SourceModel model) {
                ContentParameterModelValidator.this.validateContent(extensionModel, (ParameterizedModel)model);
            }
        }.walk(extensionModel);
    }

    private void validateNoContent(ExtensionModel extensionModel, ParameterizedModel model) {
        List<ParameterModel> contentParameters = this.getContentParameters(model);
        if (!contentParameters.isEmpty()) {
            throw this.modelException(extensionModel, model, String.format("which contains content parameters. Content parameters are not allowed on %s components", IntrospectionUtils.getComponentModelTypeName(model)));
        }
    }

    private void validateContent(ExtensionModel extensionModel, ParameterizedModel model) {
        List<ParameterModel> contentParameters = this.getContentParameters(model);
        if (contentParameters.isEmpty()) {
            return;
        }
        this.validatePrimaryContent(extensionModel, model, contentParameters);
        this.validateDsl(extensionModel, model, contentParameters);
        this.validateExpressionSupport(extensionModel, model, contentParameters);
    }

    private void validateExpressionSupport(ExtensionModel extensionModel, ParameterizedModel model, List<ParameterModel> contentParameters) {
        List<ParameterModel> expressionLess = contentParameters.stream().filter(p -> p.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED).collect(Collectors.toList());
        if (!expressionLess.isEmpty()) {
            throw this.modelException(extensionModel, model, String.format("which contains content parameters which don't allow expressions. Expressions are mandatory for all content parameters. Offending parameters are: [%s]", this.join(expressionLess)));
        }
    }

    private void validateDsl(ExtensionModel extensionModel, ParameterizedModel model, List<ParameterModel> contentParameters) {
        List<ParameterModel> offending = contentParameters.stream().filter(p -> p.getDslModel().allowsReferences()).collect(Collectors.toList());
        if (!offending.isEmpty()) {
            throw this.modelException(extensionModel, model, String.format("which contains content parameters which allow references. Offending parameters are: [%s]", this.join(offending)));
        }
    }

    private IllegalModelDefinitionException modelException(ExtensionModel extensionModel, ParameterizedModel model, String message) {
        return new IllegalModelDefinitionException(String.format("Extension '%s' defines %s '%s' %s", extensionModel.getName(), IntrospectionUtils.getComponentModelTypeName(model), model.getName(), message));
    }

    private void validatePrimaryContent(ExtensionModel extensionModel, ParameterizedModel model, List<ParameterModel> contentParameters) {
        List<ParameterModel> primaryContents = contentParameters.stream().filter(p -> p.getRole() == ParameterRole.PRIMARY_CONTENT).collect(Collectors.toList());
        if (primaryContents.isEmpty()) {
            throw this.modelException(extensionModel, model, String.format("which contains %d content parameters but none of them is primary", primaryContents.size()));
        }
        if (primaryContents.size() > 1) {
            throw this.modelException(extensionModel, model, String.format("which contains %d content parameters marked as primary. Only one primary content parameter is allowed. Offending parameters are [%s]", primaryContents.size(), this.join(primaryContents)));
        }
        this.validateDefaultsToPayload(extensionModel, model, (ParameterModel)primaryContents.get(0));
    }

    private void validateDefaultsToPayload(ExtensionModel extensionModel, ParameterizedModel model, ParameterModel parameter) {
        if (!"#[payload]".equals(parameter.getDefaultValue())) {
            throw this.modelException(extensionModel, model, String.format("which contains parameter '%s' which is set as primary content but does not default to the payload", parameter.getName()));
        }
    }

    private List<ParameterModel> getContentParameters(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(ExtensionModelUtils::isContent).collect(Collectors.toList());
    }

    private String join(List<ParameterModel> offending) {
        return Joiner.on((String)", ").join(offending);
    }
}

