/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.model.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConnectionProviderModelValidator
implements ModelValidator {
    @Override
    public void validate(final ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        HashSet<ConnectionProviderModel> globalConnectionProviders = new HashSet<ConnectionProviderModel>();
        HashMultimap configLevelConnectionProviders = HashMultimap.create();
        new ExtensionWalker((Multimap)configLevelConnectionProviders, globalConnectionProviders){
            final /* synthetic */ Multimap val$configLevelConnectionProviders;
            final /* synthetic */ Set val$globalConnectionProviders;
            {
                this.val$configLevelConnectionProviders = multimap;
                this.val$globalConnectionProviders = set;
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                ConnectionProviderModelValidator.this.validateTransactions(extensionModel, model);
                if (owner instanceof ConfigurationModel) {
                    this.val$configLevelConnectionProviders.put((Object)((ConfigurationModel)owner), (Object)model);
                } else {
                    this.val$globalConnectionProviders.add(model);
                }
            }
        }.walk(extensionModel);
        this.validateGlobalConnectionTypes(extensionModel, globalConnectionProviders);
        this.validateConfigLevelConnectionTypes(extensionModel, (Multimap<ConfigurationModel, ConnectionProviderModel>)configLevelConnectionProviders);
    }

    private void validateTransactions(ExtensionModel extensionModel, ConnectionProviderModel connectionProviderModel) {
        Class providerType = connectionProviderModel.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).orElse(null);
        Class<?> connectionType = MuleExtensionUtils.getConnectionType(connectionProviderModel);
        if (providerType != null && CachedConnectionProvider.class.isAssignableFrom(providerType) && TransactionalConnection.class.isAssignableFrom(connectionType)) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Extension '%s' contains a cached connection provider of name '%s' which provides connections of transactional type '%s'. Transactional connections cannot be produced by cached providers, since the same connection cannot join two different transactions at once", extensionModel.getName(), connectionProviderModel.getName(), connectionType.getName()));
        }
    }

    private void validateGlobalConnectionTypes(final ExtensionModel extensionModel, Set<ConnectionProviderModel> globalConnectionProviders) {
        if (CollectionUtils.isEmpty(globalConnectionProviders)) {
            return;
        }
        for (final ConnectionProviderModel connectionProviderModel : globalConnectionProviders) {
            final Class<?> connectionType = MuleExtensionUtils.getConnectionType(connectionProviderModel);
            new IdempotentExtensionWalker(){

                protected void onOperation(OperationModel operationModel) {
                    ConnectionProviderModelValidator.this.validateConnectionTypes(extensionModel, connectionProviderModel, (ComponentModel)operationModel, connectionType);
                }

                protected void onSource(SourceModel sourceModel) {
                    ConnectionProviderModelValidator.this.validateConnectionTypes(extensionModel, connectionProviderModel, (ComponentModel)sourceModel, connectionType);
                }
            }.walk(extensionModel);
        }
    }

    private void validateConfigLevelConnectionTypes(ExtensionModel extensionModel, Multimap<ConfigurationModel, ConnectionProviderModel> configLevelConnectionProviders) {
        configLevelConnectionProviders.asMap().forEach((configModel, providerModels) -> {
            for (ConnectionProviderModel providerModel : providerModels) {
                Class<?> connectionType = MuleExtensionUtils.getConnectionType(providerModel);
                configModel.getOperationModels().forEach(operationModel -> this.validateConnectionTypes(extensionModel, providerModel, (ComponentModel)operationModel, connectionType));
            }
        });
    }

    private <T> Optional<Class<T>> getConnectionType(EnrichableModel model) {
        Optional<ConnectivityModelProperty> connectivityProperty = model.getModelProperty(ConnectivityModelProperty.class);
        if (!connectivityProperty.isPresent() && model instanceof ParameterizedModel) {
            connectivityProperty = ((ParameterizedModel)model).getAllParameterModels().stream().map(p -> p.getModelProperty(ConnectivityModelProperty.class).orElse(null)).filter(p -> p != null).findFirst();
        }
        return connectivityProperty.map(property -> JavaTypeUtils.getType((MetadataType)property.getConnectionType()));
    }

    private void validateConnectionTypes(ExtensionModel extensionModel, ConnectionProviderModel providerModel, ComponentModel componentModel, Class<?> providerConnectionType) {
        this.getConnectionType((EnrichableModel)componentModel).ifPresent(connectionType -> {
            if (!connectionType.isAssignableFrom(providerConnectionType)) {
                throw new IllegalConnectionProviderModelDefinitionException(String.format("Extension '%s' defines component '%s' which requires a connection of type '%s'. However, it also defines connection provider '%s' which yields connections of incompatible type '%s'", extensionModel.getName(), componentModel.getName(), connectionType.getName(), providerModel.getName(), providerConnectionType.getName()));
            }
        });
    }
}

