/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.module.extension.internal.model.property.CallbackParameterModelProperty;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;

public final class SourceCallbackSanitizerModelEnricher
implements ModelEnricher {
    public void enrich(DescribingContext describingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onSource(SourceDeclaration declaration) {
                declaration.getParameterGroups().forEach(group -> {
                    List callbackParameters = SourceCallbackSanitizerModelEnricher.this.getCallbackParameters(group);
                    if (!callbackParameters.isEmpty()) {
                        group.getParameters().removeAll(callbackParameters);
                        group.getParameters().addAll(SourceCallbackSanitizerModelEnricher.this.sanitizeCallbackParameters(callbackParameters));
                    }
                });
            }
        }.walk((ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration());
    }

    private List<ParameterDeclaration> getCallbackParameters(ParameterGroupDeclaration declaration) {
        return declaration.getParameters().stream().filter(p -> p.getModelProperty(CallbackParameterModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    private List<ParameterDeclaration> sanitizeCallbackParameters(List<ParameterDeclaration> callbackParameters) {
        return callbackParameters.stream().map(x$0 -> new ParameterWrapper((ParameterDeclaration)x$0)).distinct().map(ParameterWrapper::getParameter).collect(Collectors.toList());
    }

    private class ParameterWrapper {
        private final ParameterDeclaration parameter;

        private ParameterWrapper(ParameterDeclaration parameter) {
            this.parameter = parameter;
        }

        public ParameterDeclaration getParameter() {
            return this.parameter;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParameterWrapper) {
                ParameterWrapper other = (ParameterWrapper)obj;
                return this.parameter.getName().equals(other.parameter.getName()) && JavaTypeUtils.getType((MetadataType)this.parameter.getType()).equals(JavaTypeUtils.getType((MetadataType)other.parameter.getType()));
            }
            return false;
        }

        public int hashCode() {
            return this.parameter.getName().hashCode();
        }
    }
}

