/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.Collection;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.extension.api.model.property.ExportModelProperty;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;

public class ExtensionTypesModelEnricher
implements ModelEnricher {
    public void enrich(DescribingContext describingContext) {
        ExtensionDeclarer declarer = describingContext.getExtensionDeclarer();
        this.declareDefaultTypes(declarer);
        this.declareExportedTypes(declarer);
        this.declareSubTypes(declarer);
    }

    private void declareExportedTypes(ExtensionDeclarer declarer) {
        ((ExtensionDeclaration)declarer.getDeclaration()).getModelProperty(ExportModelProperty.class).ifPresent(p -> this.registerTypes(declarer, p.getExportedTypes()));
    }

    private void declareSubTypes(ExtensionDeclarer declarer) {
        ((ExtensionDeclaration)declarer.getDeclaration()).getSubTypes().forEach(type -> this.registerTypes(declarer, type.getSubTypes()));
    }

    private void declareDefaultTypes(final ExtensionDeclarer declarer) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                ExtensionTypesModelEnricher.this.registerType(declarer, declaration.getType());
            }

            @Override
            public void onSource(SourceDeclaration declaration) {
                ExtensionTypesModelEnricher.this.registerType(declarer, (ComponentDeclaration)declaration);
            }

            @Override
            public void onOperation(OperationDeclaration declaration) {
                ExtensionTypesModelEnricher.this.registerType(declarer, (ComponentDeclaration)declaration);
            }
        }.walk((ExtensionDeclaration)declarer.getDeclaration());
    }

    private void registerTypes(ExtensionDeclarer declarer, Collection<MetadataType> types) {
        types.forEach(type -> this.registerType(declarer, (MetadataType)type));
    }

    private void registerType(ExtensionDeclarer declarer, ComponentDeclaration declaration) {
        this.registerType(declarer, declaration.getOutput().getType());
        this.registerType(declarer, declaration.getOutputAttributes().getType());
    }

    private void registerType(final ExtensionDeclarer declarer, MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                declarer.withType(objectType);
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                dictionaryType.getKeyType().accept((MetadataTypeVisitor)this);
                dictionaryType.getValueType().accept((MetadataTypeVisitor)this);
            }

            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            }
        });
    }
}

