/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.describer.model.MethodElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.introspection.enricher.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.model.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ErrorsModelEnricher
implements ModelEnricher {
    private ErrorsModelFactory errorModelDescriber;

    public void enrich(DescribingContext describingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration();
        Optional implementingType = declaration.getModelProperty(ImplementingTypeModelProperty.class);
        if (implementingType.isPresent()) {
            ExtensionTypeWrapper extensionElement = new ExtensionTypeWrapper(((ImplementingTypeModelProperty)implementingType.get()).getType());
            extensionElement.getAnnotation(ErrorTypes.class).ifPresent(errorTypesAnnotation -> {
                String extensionNamespace = MuleExtensionUtils.getExtensionsErrorNamespace(declaration);
                final ErrorTypeDefinition[] errorTypes = (ErrorTypeDefinition[])errorTypesAnnotation.value().getEnumConstants();
                if (errorTypes.length > 0) {
                    this.errorModelDescriber = new ErrorsModelFactory(errorTypes, extensionNamespace);
                    this.errorModelDescriber.getErrorModels().forEach(arg_0 -> ((ExtensionDeclaration)declaration).addErrorModel(arg_0));
                    new IdempotentDeclarationWalker(){

                        @Override
                        public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                            Optional modelProperty = declaration.getModelProperty(ImplementingMethodModelProperty.class);
                            modelProperty.ifPresent(implementingMethodModelProperty -> {
                                MethodWrapper methodElement = new MethodWrapper(implementingMethodModelProperty.getMethod());
                                ErrorsModelEnricher.this.registerOperationErrorTypes(methodElement, declaration, ErrorsModelEnricher.this.errorModelDescriber, errorTypes);
                            });
                        }
                    }.walk(declaration);
                }
            });
        }
    }

    private void registerOperationErrorTypes(MethodElement operationMethod, OperationDeclaration operation, ErrorsModelFactory errorModelDescriber, ErrorTypeDefinition<?>[] extensionErrorTypes) {
        operationMethod.getAnnotation(Throws.class).ifPresent(throwsAnnotation -> {
            Class[] providers = throwsAnnotation.value();
            Stream.of(providers).forEach(provider -> {
                try {
                    ErrorTypeProvider errorTypeProvider = (ErrorTypeProvider)provider.newInstance();
                    errorTypeProvider.getErrorTypes().stream().map(error -> this.validateOperationThrows(extensionErrorTypes, (ErrorTypeDefinition)error)).map(errorModelDescriber::getErrorModel).forEach(arg_0 -> ((OperationDeclaration)operation).addError(arg_0));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create ErrorTypeProvider of type " + provider.getName())), (Throwable)e);
                }
            });
        });
    }

    private ErrorTypeDefinition validateOperationThrows(ErrorTypeDefinition<?>[] errorTypes, ErrorTypeDefinition error) {
        Class<?> extensionErrorType = errorTypes.getClass().getComponentType();
        if (!error.getClass().equals(extensionErrorType) && !error.getClass().getSuperclass().equals(extensionErrorType)) {
            throw new IllegalModelDefinitionException(String.format("Invalid operation throws detected, the extension declared to throw errors of %s type, but an error of %s type has been detected", extensionErrorType, error.getClass()));
        }
        return error;
    }
}

