/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.model.property.ConnectivityModelProperty;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionParameter;
import org.mule.runtime.module.extension.internal.introspection.describer.model.WithParameters;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.ParameterizableTypeWrapper;
import org.mule.runtime.module.extension.internal.introspection.enricher.AbstractAnnotatedModelEnricher;
import org.mule.runtime.module.extension.internal.model.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionInterceptor;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ConnectionModelEnricher
extends AbstractAnnotatedModelEnricher {
    private final MetadataType transactionalActionType;
    private ClassTypeLoader typeLoader;

    public ConnectionModelEnricher() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        this.transactionalActionType = typeLoader.load(OperationTransactionalAction.class);
    }

    public void enrich(final DescribingContext describingContext) {
        Optional<ImplementingTypeModelProperty> implementingType = this.extractExtensionType((BaseDeclaration<? extends BaseDeclaration>)describingContext.getExtensionDeclarer().getDeclaration());
        if (implementingType.isPresent()) {
            this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(Thread.currentThread().getContextClassLoader());
            new IdempotentDeclarationWalker(){

                @Override
                public void onOperation(OperationDeclaration declaration) {
                    Optional implementingProperty = declaration.getModelProperty(ImplementingMethodModelProperty.class);
                    if (implementingProperty.isPresent()) {
                        Optional connectivityModelProperty = ConnectionModelEnricher.this.addModelProperty((BaseDeclaration)declaration, new MethodWrapper(((ImplementingMethodModelProperty)implementingProperty.get()).getMethod()));
                        connectivityModelProperty.ifPresent(connection -> ConnectionModelEnricher.this.addConnectionInterceptors(declaration, describingContext, connection));
                    }
                }

                @Override
                public void onSource(SourceDeclaration declaration) {
                    declaration.getModelProperty(ImplementingTypeModelProperty.class).ifPresent(implementingProperty -> ConnectionModelEnricher.this.addModelProperty((BaseDeclaration)declaration, new ParameterizableTypeWrapper((Class)implementingProperty.getType())));
                }
            }.walk((ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration());
        }
    }

    private void addTransactionalActionParameter(DescribingContext describingContext, OperationDeclaration declaration) {
        declaration.getAllParameters().stream().filter(parameter -> "transactionalAction".equals(parameter.getName())).findAny().ifPresent(p -> {
            throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' from extension '%s' defines a parameter named '%s' which is a reserved word", declaration.getName(), ((ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration()).getName(), "transactionalAction"));
        });
        ParameterDeclaration transactionParameter = new ParameterDeclaration("transactionalAction");
        transactionParameter.setType(this.transactionalActionType, false);
        transactionParameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        transactionParameter.setRequired(false);
        transactionParameter.setDefaultValue((Object)OperationTransactionalAction.JOIN_IF_POSSIBLE);
        transactionParameter.setDescription("The type of joining action that operations can take regarding transactions.");
        transactionParameter.setLayoutModel(LayoutModel.builder().tabName("Transaction").build());
        declaration.getParameterGroup("General").addParameter(transactionParameter);
    }

    private void addConnectionInterceptors(OperationDeclaration declaration, DescribingContext describingContext, ConnectivityModelProperty connection) {
        MuleExtensionUtils.addInterceptorFactory((BaseDeclaration)declaration, ConnectionInterceptor::new);
        if (connection.supportsTransactions()) {
            this.addTransactionalActionParameter(describingContext, declaration);
        }
    }

    private Optional<ConnectivityModelProperty> addModelProperty(BaseDeclaration declaration, WithParameters methodWrapper) {
        List<ExtensionParameter> connectionParameters = methodWrapper.getParametersAnnotatedWith(Connection.class);
        if (!connectionParameters.isEmpty()) {
            ConnectivityModelProperty modelProperty = new ConnectivityModelProperty(connectionParameters.get(0).getMetadataType(this.typeLoader));
            declaration.addModelProperty((ModelProperty)modelProperty);
            return Optional.of(modelProperty);
        }
        return Optional.empty();
    }
}

