/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.RequireNameField;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;
import org.reflections.ReflectionUtils;

public final class ConfigNameModelEnricher
implements ModelEnricher {
    public void enrich(DescribingContext describingContext) {
        new IdempotentDeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                ConfigNameModelEnricher.this.doEnrich((BaseDeclaration)declaration);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                ConfigNameModelEnricher.this.doEnrich((BaseDeclaration)declaration);
            }
        }.walk((ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration());
    }

    private void doEnrich(BaseDeclaration declaration) {
        declaration.getModelProperty(ImplementingTypeModelProperty.class).ifPresent(p -> {
            ImplementingTypeModelProperty typeProperty = (ImplementingTypeModelProperty)p;
            Set fields = ReflectionUtils.getAllFields(typeProperty.getType(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(ConfigName.class)});
            if (CollectionUtils.isEmpty((Collection)fields)) {
                return;
            }
            if (fields.size() > 1) {
                throw new IllegalConfigurationModelDefinitionException(String.format("Only one configuration field is allowed to be annotated with @%s, but class '%s' has %d fields with such annotation. Offending fields are: [%s]", ConfigName.class.getSimpleName(), typeProperty.getType().getName(), fields.size(), Joiner.on((String)", ").join((Iterable)fields.stream().map(Field::getName).collect(Collectors.toList()))));
            }
            Field configNameField = (Field)fields.iterator().next();
            if (!String.class.equals(configNameField.getType())) {
                throw new IllegalConfigurationModelDefinitionException(String.format("Config class '%s' declares the field '%s' which is annotated with @%s and is of type '%s'. Only fields of type String are allowed to carry such annotation", typeProperty.getType().getName(), configNameField.getName(), ConfigName.class.getSimpleName(), configNameField.getType().getName()));
            }
            declaration.addModelProperty((ModelProperty)new RequireNameField(configNameField));
        });
    }
}

