/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.describer.model.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ParameterElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.TypeWrapper;
import org.springframework.core.ResolvableType;

public final class ParameterWrapper
implements ParameterElement {
    private final Parameter parameter;
    private final Method owner;
    private final int index;

    public ParameterWrapper(Method owner, int index) {
        this.index = index;
        this.parameter = owner.getParameters()[index];
        this.owner = owner;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public TypeWrapper getType() {
        return new TypeWrapper(this.parameter.getType());
    }

    @Override
    public MetadataType getMetadataType(ClassTypeLoader typeLoader) {
        return typeLoader.load(ResolvableType.forMethodParameter((Method)this.owner, (int)this.index).getType());
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.parameter.getAnnotations();
    }

    @Override
    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable(this.parameter.getAnnotation(annotationClass));
    }

    @Override
    public String getName() {
        return this.parameter.getName();
    }

    @Override
    public String getOwnerDescription() {
        return String.format("Method: '%s'", this.owner.getName());
    }
}

