/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.describer.model.runtime;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ConfigurationElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.MethodElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ParameterizableTypeElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.ComponentWrapper;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.ConfigurationWrapper;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class ExtensionTypeWrapper<T>
extends ComponentWrapper
implements ExtensionElement,
ParameterizableTypeElement {
    public ExtensionTypeWrapper(Class<T> aClass) {
        super(aClass);
    }

    @Override
    public List<ConfigurationElement> getConfigurations() {
        Optional<Configurations> optionalConfigurations = this.getAnnotation(Configurations.class);
        if (optionalConfigurations.isPresent()) {
            Configurations configurations = optionalConfigurations.get();
            return Stream.of(configurations.value()).map(ConfigurationWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<MethodElement> getOperations() {
        return this.getAnnotation(Operations.class).map(classes -> Stream.of(classes.value()).flatMap(clazz -> IntrospectionUtils.getOperationMethods(clazz).stream()).map(clazz -> new MethodWrapper((Method)clazz)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

