/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.describer.contributor;

import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.operation.ParameterResolver;
import org.mule.runtime.module.extension.internal.introspection.describer.ParameterResolverTypeModelProperty;
import org.mule.runtime.module.extension.internal.introspection.describer.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionParameter;
import org.mule.runtime.module.extension.internal.introspection.utils.ParameterDeclarationContext;

public class ParameterResolverParameterTypeContributor
implements ParameterDeclarerContributor {
    private ClassTypeLoader typeLoader;

    public ParameterResolverParameterTypeContributor(ClassTypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    @Override
    public void contribute(ExtensionParameter parameter, ParameterDeclarer declarer, ParameterDeclarationContext declarationContext) {
        MetadataType metadataType = parameter.getMetadataType(this.typeLoader);
        if (ParameterResolver.class.isAssignableFrom(parameter.getType().getDeclaringClass())) {
            Optional expressionResolverType = JavaTypeUtils.getGenericTypeAt((MetadataType)metadataType, (int)0, (ClassTypeLoader)this.typeLoader);
            if (!expressionResolverType.isPresent()) {
                throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] from the Operation [%s] doesn't specify the %s parameterized type", parameter.getName(), declarationContext.getName(), ParameterResolver.class.getSimpleName()));
            }
            metadataType = (MetadataType)expressionResolverType.get();
            declarer.ofType(metadataType);
            declarer.withModelProperty((ModelProperty)new ParameterResolverTypeModelProperty());
        }
    }
}

