/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.describer;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ElementDslModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.Declarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.ArrayUtils;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExtensionOf;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.RestrictedTo;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.Describer;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.model.property.PagedOperationModelProperty;
import org.mule.runtime.extension.api.runtime.operation.InterceptingCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.introspection.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.introspection.describer.DefaultConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.introspection.describer.TypeAwareConfigurationFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.contributor.FunctionParameterTypeContributor;
import org.mule.runtime.module.extension.internal.introspection.describer.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.introspection.describer.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.introspection.describer.contributor.ParameterResolverParameterTypeContributor;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ComponentElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ConfigurationElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ConnectionProviderElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionParameter;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionTypeFactory;
import org.mule.runtime.module.extension.internal.introspection.describer.model.FieldElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.MethodElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.OperationContainerElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.SourceElement;
import org.mule.runtime.module.extension.internal.introspection.describer.model.Type;
import org.mule.runtime.module.extension.internal.introspection.describer.model.WithAnnotations;
import org.mule.runtime.module.extension.internal.introspection.describer.model.WithConnectionProviders;
import org.mule.runtime.module.extension.internal.introspection.describer.model.WithMessageSources;
import org.mule.runtime.module.extension.internal.introspection.describer.model.WithOperationContainers;
import org.mule.runtime.module.extension.internal.introspection.describer.model.WithParameters;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.FieldWrapper;
import org.mule.runtime.module.extension.internal.introspection.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.introspection.version.VersionResolver;
import org.mule.runtime.module.extension.internal.model.property.CallbackParameterModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ExceptionEnricherModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ExtendingOperationModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.InterceptingModelProperty;
import org.mule.runtime.module.extension.internal.model.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.model.property.OperationExecutorModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.model.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.model.property.SourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.model.property.TypeRestrictionModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveOperationExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceFactory;
import org.mule.runtime.module.extension.internal.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class AnnotationsBasedDescriber
implements Describer {
    public static final String DESCRIBER_ID = "annotations";
    public static final String TYPE_PROPERTY_NAME = "type";
    public static final String DEFAULT_CONNECTION_PROVIDER_NAME = "connection";
    private static final String CUSTOM_CONNECTION_PROVIDER_SUFFIX = "-connection";
    private static final String CONNECTION_PROVIDER = "Connection Provider";
    private static final String CONFIGURATION = "Configuration";
    private static final String SOURCE = "Source";
    private static final String OPERATION = "Operation";
    private final Class<?> extensionType;
    private final VersionResolver versionResolver;
    private final ClassTypeLoader typeLoader;
    private final Map<MethodElement, OperationDeclarer> operationDeclarers = new HashMap<MethodElement, OperationDeclarer>();
    private final Map<Class<?>, SourceDeclarer> sourceDeclarers = new HashMap();
    private final Map<Class<?>, ConnectionProviderDeclarer> connectionProviderDeclarers = new HashMap();
    private List<ParameterDeclarerContributor> fieldParameterContributors;
    private List<ParameterDeclarerContributor> methodParameterContributors;

    public AnnotationsBasedDescriber(Class<?> extensionType, VersionResolver versionResolver) {
        Preconditions.checkArgument((extensionType != null ? 1 : 0) != 0, (String)String.format("describer %s does not specify an extension type", this.getClass().getName()));
        this.extensionType = extensionType;
        this.versionResolver = versionResolver;
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(extensionType.getClassLoader());
        this.fieldParameterContributors = ImmutableList.of((Object)new InfrastructureFieldContributor(), (Object)new FunctionParameterTypeContributor(this.typeLoader));
        this.methodParameterContributors = ImmutableList.of((Object)new ParameterResolverParameterTypeContributor(this.typeLoader), (Object)new FunctionParameterTypeContributor(this.typeLoader));
    }

    public final ExtensionDeclarer describe(DescribingContext context) {
        ExtensionElement extensionElement = ExtensionTypeFactory.getExtensionType(this.extensionType);
        Extension extension = MuleExtensionAnnotationParser.getExtension(this.extensionType);
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(extension.name()).onVersion(this.getVersion(extension)).fromVendor(extension.vendor()).withCategory(extension.category()).withMinMuleVersion(new MuleVersion(extension.minMuleVersion())).describedAs(extension.description()).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(this.extensionType));
        this.addExceptionEnricher(extensionElement, (HasModelProperties)declarer);
        this.declareConfigurations(declarer, extensionElement);
        this.declareConnectionProviders((HasConnectionProviderDeclarer)declarer, extensionElement);
        if (!CollectionUtils.isEmpty(extensionElement.getConfigurations())) {
            this.declareOperations(declarer, (HasOperationDeclarer)declarer, extensionElement.getOperations(), false);
            extensionElement.getSources().forEach(source -> this.declareMessageSource(declarer, (HasSourceDeclarer)declarer, (SourceElement)source, false));
        }
        return declarer;
    }

    private <M extends WithAnnotations> HasModelProperties addExceptionEnricher(M model, HasModelProperties declarer) {
        MuleExtensionAnnotationParser.getExceptionEnricherFactory(model).map(ExceptionEnricherModelProperty::new).ifPresent(arg_0 -> ((HasModelProperties)declarer).withModelProperty(arg_0));
        return declarer;
    }

    private String getVersion(Extension extension) {
        return this.versionResolver.resolveVersion(extension);
    }

    private void declareConfigurations(ExtensionDeclarer declaration, ExtensionElement extensionElement) {
        List<ConfigurationElement> configurations = extensionElement.getConfigurations();
        if (configurations.isEmpty()) {
            this.declareConfiguration(declaration, extensionElement, extensionElement);
        } else {
            for (ConfigurationElement configuration : configurations) {
                this.declareConfiguration(declaration, extensionElement, configuration);
            }
        }
    }

    private void declareConfiguration(ExtensionDeclarer declarer, ExtensionElement extensionType, ComponentElement configurationType) {
        ConfigurationDeclarer configurationDeclarer;
        this.checkConfigurationIsNotAnOperation(configurationType.getDeclaringClass());
        java.util.Optional<Configuration> configurationAnnotation = configurationType.getAnnotation(Configuration.class);
        if (configurationAnnotation.isPresent()) {
            Configuration configuration = configurationAnnotation.get();
            configurationDeclarer = declarer.withConfig(configuration.name()).describedAs(configuration.description());
        } else {
            configurationDeclarer = declarer.withConfig("config").describedAs("Default configuration");
        }
        configurationDeclarer.withModelProperty((ModelProperty)new ConfigurationFactoryModelProperty(new TypeAwareConfigurationFactory(configurationType.getDeclaringClass(), extensionType.getDeclaringClass().getClassLoader()))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(configurationType.getDeclaringClass()));
        this.declareFieldBasedParameters((ParameterizedDeclarer)configurationDeclarer, configurationType.getParameters(), new ParameterDeclarationContext(CONFIGURATION, (NamedDeclaration)configurationDeclarer.getDeclaration()));
        this.declareOperations(declarer, (HasOperationDeclarer)configurationDeclarer, configurationType);
        this.declareMessageSources(declarer, (HasSourceDeclarer)configurationDeclarer, configurationType);
        this.declareConnectionProviders((HasConnectionProviderDeclarer)configurationDeclarer, configurationType);
    }

    private void declareMessageSources(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer declarer, WithMessageSources typeComponent) {
        typeComponent.getSources().forEach(source -> this.declareMessageSource(extensionDeclarer, declarer, (SourceElement)source, true));
    }

    private void declareMessageSource(ExtensionDeclarer extensionDeclarer, HasSourceDeclarer declarer, SourceElement sourceType, boolean supportsConfig) {
        java.util.Optional<ExtensionParameter> configParameter = this.getConfigParameter(sourceType);
        java.util.Optional<ExtensionParameter> connectionParameter = this.getConnectionParameter(sourceType);
        if (this.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter)) {
            throw new IllegalSourceModelDefinitionException(String.format("Source '%s' is defined at the extension level but it requires a config parameter. Remove such parameter or move the source to the proper config", sourceType.getName()));
        }
        HasSourceDeclarer actualDeclarer = (HasSourceDeclarer)this.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, connectionParameter);
        SourceDeclarer source = this.sourceDeclarers.get(sourceType.getDeclaringClass());
        if (source != null) {
            actualDeclarer.withMessageSource(source);
            return;
        }
        source = actualDeclarer.withMessageSource(sourceType.getAlias());
        List<java.lang.reflect.Type> sourceGenerics = sourceType.getSuperClassGenerics();
        if (sourceGenerics.size() != 2) {
            throw new IllegalModelDefinitionException(String.format("Message source class '%s' was expected to have 2 generic types (one for the Payload type and another for the Attributes type) but %d were found", sourceType.getName(), sourceGenerics.size()));
        }
        ((SourceDeclarer)((SourceDeclarer)source.hasResponse(sourceType.isAnnotatedWith(EmitsResponse.class)).withModelProperty((ModelProperty)new SourceFactoryModelProperty(new DefaultSourceFactory(sourceType.getDeclaringClass())))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(sourceType.getDeclaringClass()))).withOutput().ofType(this.typeLoader.load(sourceGenerics.get(0)));
        source.withOutputAttributes().ofType(this.typeLoader.load(sourceGenerics.get(1)));
        this.addExceptionEnricher(sourceType, (HasModelProperties)source);
        this.declareSourceParameters(sourceType, source);
        this.declareSourceCallback(sourceType, source);
        this.sourceDeclarers.put(sourceType.getDeclaringClass(), source);
    }

    private void declareSourceParameters(SourceElement sourceType, SourceDeclarer source) {
        this.declareFieldBasedParameters((ParameterizedDeclarer)source, sourceType.getParameters(), new ParameterDeclarationContext(SOURCE, (NamedDeclaration)source.getDeclaration())).forEach(p -> p.withExpressionSupport(ExpressionSupport.NOT_SUPPORTED));
    }

    private void declareSourceCallback(SourceElement sourceType, SourceDeclarer source) {
        java.util.Optional<MethodElement> onResponseMethod = sourceType.getOnResponseMethod();
        java.util.Optional<MethodElement> onErrorMethod = sourceType.getOnErrorMethod();
        this.declareSourceCallbackParameters(source, onResponseMethod, CallbackParameterModelProperty.CallbackPhase.ON_SUCCESS);
        this.declareSourceCallbackParameters(source, onErrorMethod, CallbackParameterModelProperty.CallbackPhase.ON_ERROR);
        source.withModelProperty((ModelProperty)new SourceCallbackModelProperty(this.getMethod(onResponseMethod), this.getMethod(onErrorMethod)));
    }

    private void declareSourceCallbackParameters(SourceDeclarer source, java.util.Optional<MethodElement> sourceCallback, CallbackParameterModelProperty.CallbackPhase callbackPhase) {
        sourceCallback.ifPresent(method -> this.declareMethodBasedParameters((ParameterizedDeclarer)source, method.getParameters(), new ParameterDeclarationContext(SOURCE, (NamedDeclaration)source.getDeclaration())).forEach(p -> p.withModelProperty((ModelProperty)new CallbackParameterModelProperty(callbackPhase))));
    }

    private java.util.Optional<Method> getMethod(java.util.Optional<MethodElement> method) {
        return method.map(MethodElement::getMethod);
    }

    private void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, WithOperationContainers operationContainers) {
        operationContainers.getOperationContainers().forEach(operationContainer -> this.declareOperations(extensionDeclarer, declarer, (OperationContainerElement)operationContainer));
    }

    private Class<?>[] getOperationClasses(Class<?> extensionType) {
        Operations operations = extensionType.getAnnotation(Operations.class);
        return operations == null ? ArrayUtils.EMPTY_CLASS_ARRAY : operations.value();
    }

    private void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, OperationContainerElement operationsContainer) {
        this.declareOperations(extensionDeclarer, declarer, operationsContainer.getOperations(), true);
    }

    private void declareOperations(ExtensionDeclarer extensionDeclarer, HasOperationDeclarer declarer, List<MethodElement> operations, boolean supportsConfig) {
        for (MethodElement operationMethod : operations) {
            Class declaringClass = operationMethod.getDeclaringClass();
            this.checkOperationIsNotAnExtension(declaringClass);
            Method method = operationMethod.getMethod();
            java.util.Optional<ExtensionParameter> configParameter = this.getConfigParameter(operationMethod);
            java.util.Optional<ExtensionParameter> connectionParameter = this.getConnectionParameter(operationMethod);
            if (this.isInvalidConfigSupport(supportsConfig, configParameter, connectionParameter)) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' is defined at the extension level but it requires a config. Remove such parameter or move the operation to the proper config", method.getName()));
            }
            HasOperationDeclarer actualDeclarer = (HasOperationDeclarer)this.selectDeclarerBasedOnConfig(extensionDeclarer, (Declarer)declarer, configParameter, connectionParameter);
            if (this.operationDeclarers.containsKey(operationMethod)) {
                actualDeclarer.withOperation(this.operationDeclarers.get(operationMethod));
                continue;
            }
            OperationDeclarer operation = (OperationDeclarer)((OperationDeclarer)actualDeclarer.withOperation(operationMethod.getAlias()).withModelProperty((ModelProperty)new ImplementingMethodModelProperty(method))).withModelProperty((ModelProperty)new OperationExecutorModelProperty(new ReflectiveOperationExecutorFactory(declaringClass, method)));
            this.addExceptionEnricher(operationMethod, (HasModelProperties)operation);
            operation.withOutput().ofType(IntrospectionUtils.getMethodReturnType(method, this.typeLoader));
            operation.withOutputAttributes().ofType(IntrospectionUtils.getMethodReturnAttributesType(method, this.typeLoader));
            this.addInterceptingCallbackModelProperty(operationMethod, operation);
            this.addPagedOperationModelProperty(operationMethod, operation, supportsConfig);
            this.declareMethodBasedParameters((ParameterizedDeclarer)operation, operationMethod.getParameters(), new ParameterDeclarationContext(OPERATION, (NamedDeclaration)operation.getDeclaration()));
            this.calculateExtendedTypes(declaringClass, method, operation);
            this.operationDeclarers.put(operationMethod, operation);
        }
    }

    private boolean isInvalidConfigSupport(boolean supportsConfig, java.util.Optional<ExtensionParameter> ... parameters) {
        return !supportsConfig && Stream.of(parameters).anyMatch(java.util.Optional::isPresent);
    }

    private Declarer selectDeclarerBasedOnConfig(ExtensionDeclarer extensionDeclarer, Declarer declarer, java.util.Optional<ExtensionParameter> ... parameters) {
        for (java.util.Optional<ExtensionParameter> parameter : parameters) {
            if (!parameter.isPresent()) continue;
            return declarer;
        }
        return extensionDeclarer;
    }

    private java.util.Optional<ExtensionParameter> getConfigParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(UseConfig.class).stream().findFirst();
    }

    private java.util.Optional<ExtensionParameter> getConnectionParameter(WithParameters element) {
        return element.getParametersAnnotatedWith(Connection.class).stream().findFirst();
    }

    private void declareConnectionProviders(HasConnectionProviderDeclarer declarer, WithConnectionProviders withConnectionProviders) {
        withConnectionProviders.getConnectionProviders().forEach(provider -> this.declareConnectionProvider(declarer, (ConnectionProviderElement)provider));
    }

    private void declareConnectionProvider(HasConnectionProviderDeclarer declarer, ConnectionProviderElement providerType) {
        List<Class<?>> providerGenerics;
        Class providerClass = providerType.getDeclaringClass();
        ConnectionProviderDeclarer providerDeclarer = this.connectionProviderDeclarers.get(providerClass);
        if (providerDeclarer != null) {
            declarer.withConnectionProvider(providerDeclarer);
            return;
        }
        String name = providerType.getAlias() + CUSTOM_CONNECTION_PROVIDER_SUFFIX;
        String description = providerType.getDescription();
        if (providerType.getName().equals(providerType.getAlias())) {
            name = DEFAULT_CONNECTION_PROVIDER_NAME;
        }
        if ((providerGenerics = providerType.getInterfaceGenerics(ConnectionProvider.class)).size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection provider class '%s' was expected to have 1 generic type (for the connection type) but %d were found", providerType.getName(), providerGenerics.size()));
        }
        providerDeclarer = declarer.withConnectionProvider(name).describedAs(description).withModelProperty((ModelProperty)new ConnectionProviderFactoryModelProperty(new DefaultConnectionProviderFactory(providerClass, this.extensionType.getClassLoader()))).withModelProperty((ModelProperty)new ConnectionTypeModelProperty(providerGenerics.get(0))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(providerClass));
        ConnectionManagementType managementType = ConnectionManagementType.NONE;
        if (PoolingConnectionProvider.class.isAssignableFrom(providerClass)) {
            managementType = ConnectionManagementType.POOLING;
        } else if (CachedConnectionProvider.class.isAssignableFrom(providerClass)) {
            managementType = ConnectionManagementType.CACHED;
        }
        providerDeclarer.withConnectionManagementType(managementType);
        this.connectionProviderDeclarers.put(providerClass, providerDeclarer);
        this.declareFieldBasedParameters((ParameterizedDeclarer)providerDeclarer, providerType.getParameters(), new ParameterDeclarationContext(CONNECTION_PROVIDER, (NamedDeclaration)providerDeclarer.getDeclaration()));
    }

    private List<ParameterDeclarer> declareFieldBasedParameters(ParameterizedDeclarer component, List<ExtensionParameter> parameters, ParameterDeclarationContext componentName) {
        return this.declareParameters(component, parameters, this.fieldParameterContributors, componentName, java.util.Optional.empty());
    }

    private List<ParameterDeclarer> declareMethodBasedParameters(ParameterizedDeclarer component, List<ExtensionParameter> parameters, ParameterDeclarationContext componentName) {
        return this.declareParameters(component, parameters, this.methodParameterContributors, componentName, java.util.Optional.empty());
    }

    private List<ParameterDeclarer> declareParameters(ParameterizedDeclarer component, List<? extends ExtensionParameter> parameters, List<ParameterDeclarerContributor> contributors, ParameterDeclarationContext declarationContext, java.util.Optional<ParameterGroupDeclarer> parameterGroupDeclarer) {
        ArrayList<ParameterDeclarer> declarerList = new ArrayList<ParameterDeclarer>();
        this.checkAnnotationsNotUsedMoreThanOnce(parameters, Connection.class, UseConfig.class, MetadataKeyId.class);
        for (ExtensionParameter extensionParameter : parameters) {
            if (!extensionParameter.shouldBeAdvertised() || this.declaredAsGroup(component, contributors, declarationContext, extensionParameter)) continue;
            ParameterGroupDeclarer groupDeclarer = parameterGroupDeclarer.orElseGet(() -> ((ParameterizedDeclarer)component).onDefaultParameterGroup());
            Object parameter = extensionParameter.isRequired() ? groupDeclarer.withRequiredParameter(extensionParameter.getAlias()) : groupDeclarer.withOptionalParameter(extensionParameter.getAlias()).defaultingTo(extensionParameter.defaultValue().isPresent() ? extensionParameter.defaultValue().get() : null);
            parameter.ofType(extensionParameter.getMetadataType(this.typeLoader)).describedAs(extensionParameter.getDescription());
            this.parseParameterRole(extensionParameter, (ParameterDeclarer)parameter);
            this.parseExpressionSupport(extensionParameter, (ParameterDeclarer)parameter);
            this.parseNullSafe(extensionParameter, (ParameterDeclarer)parameter);
            this.addTypeRestrictions(extensionParameter, (ParameterDeclarer)parameter);
            this.parseLayout(extensionParameter, (ParameterDeclarer)parameter);
            this.addImplementingTypeModelProperty(extensionParameter, (ParameterDeclarer)parameter);
            this.parseXmlHints(extensionParameter, (ParameterDeclarer)parameter);
            contributors.forEach(arg_0 -> AnnotationsBasedDescriber.lambda$declareParameters$7(extensionParameter, (ParameterDeclarer)parameter, declarationContext, arg_0));
            declarerList.add((ParameterDeclarer)parameter);
        }
        return declarerList;
    }

    private boolean declaredAsGroup(ParameterizedDeclarer component, List<ParameterDeclarerContributor> contributors, ParameterDeclarationContext declarationContext, ExtensionParameter groupParameter) {
        ParameterGroup groupAnnotation = groupParameter.getAnnotation(ParameterGroup.class).orElse(null);
        if (groupAnnotation == null) {
            return false;
        }
        String groupName = groupAnnotation.value();
        if ("General".equals(groupName)) {
            throw new IllegalParameterModelDefinitionException(String.format("%s '%s' defines parameter group of name '%s' which is the default one. @%s cannot be used with the default group name", IntrospectionUtils.getComponentModelTypeName(component), ((NamedDeclaration)component.getDeclaration()).getName(), groupName, ParameterGroup.class.getSimpleName()));
        }
        Type type = groupParameter.getType();
        List<FieldElement> nestedGroups = type.getAnnotatedFields(ParameterGroup.class);
        if (!nestedGroups.isEmpty()) {
            throw new IllegalParameterModelDefinitionException(String.format("Class '%s' is used as a @%s but contains fields which also hold that annotation. Nesting groups is not allowed. Offending fields are: [%s]", type.getName(), ParameterGroup.class.getSimpleName(), nestedGroups.stream().map(element -> element.getName()).collect(Collectors.joining(","))));
        }
        List<FieldElement> annotatedParameters = type.getAnnotatedFields(org.mule.runtime.extension.api.annotation.param.Parameter.class);
        if (groupParameter.isAnnotatedWith(Optional.class)) {
            throw new IllegalParameterModelDefinitionException(String.format("@%s can not be applied alongside with @%s. Affected parameter is [%s].", Optional.class.getSimpleName(), ParameterGroup.class.getSimpleName(), groupParameter.getName()));
        }
        ParameterGroupDeclarer declarer = component.withParameterGroup(groupName);
        if (declarer.getDeclaration().getModelProperty(ParameterGroupModelProperty.class).isPresent()) {
            throw new IllegalParameterModelDefinitionException(String.format("Parameter group '%s' has already been declared on %s '%s'", groupName, IntrospectionUtils.getComponentDeclarationTypeName(component), ((NamedDeclaration)component.getDeclaration()).getName()));
        }
        declarer.withModelProperty((ModelProperty)new ParameterGroupModelProperty(new ParameterGroupDescriptor(groupName, type, groupParameter.getDeclaringElement())));
        type.getAnnotation(ExclusiveOptionals.class).ifPresent(annotation -> {
            Set optionalParamNames = annotatedParameters.stream().filter(f -> !f.isRequired()).map(f -> f.getAlias()).collect(Collectors.toSet());
            declarer.withExclusiveOptionals(optionalParamNames, annotation.isOneRequired());
        });
        MuleExtensionAnnotationParser.parseLayoutAnnotations(groupParameter, LayoutModel.builder()).ifPresent(arg_0 -> ((ParameterGroupDeclarer)declarer).withLayout(arg_0));
        if (!annotatedParameters.isEmpty()) {
            this.declareParameters(component, annotatedParameters, contributors, declarationContext, java.util.Optional.ofNullable(declarer));
        } else {
            this.declareParameters(component, IntrospectionUtils.getFieldsWithGetters(type.getDeclaringClass()).stream().map(FieldWrapper::new).collect(Collectors.toList()), contributors, declarationContext, java.util.Optional.ofNullable(declarer));
        }
        return true;
    }

    private void checkConfigurationIsNotAnOperation(Class<?> configurationType) {
        Class<?>[] operationClasses;
        for (Class<?> operationClass : operationClasses = this.getOperationClasses(this.extensionType)) {
            if (!configurationType.isAssignableFrom(operationClass) && !operationClass.isAssignableFrom(configurationType)) continue;
            throw new IllegalConfigurationModelDefinitionException(String.format("Configuration class '%s' cannot be the same class (nor a derivative) of any operation class '%s", configurationType.getName(), operationClass.getName()));
        }
    }

    private void checkOperationIsNotAnExtension(Class<?> operationType) {
        if (operationType.isAssignableFrom(this.extensionType) || this.extensionType.isAssignableFrom(operationType)) {
            throw new IllegalOperationModelDefinitionException(String.format("Operation class '%s' cannot be the same class (nor a derivative) of the extension class '%s", operationType.getName(), this.extensionType.getName()));
        }
    }

    private void calculateExtendedTypes(Class<?> actingClass, Method method, OperationDeclarer operation) {
        ExtensionOf extensionOf = method.getAnnotation(ExtensionOf.class);
        if (extensionOf == null) {
            extensionOf = actingClass.getAnnotation(ExtensionOf.class);
        }
        if (extensionOf != null) {
            operation.withModelProperty(new ExtendingOperationModelProperty(extensionOf.value()));
        } else if (this.isExtensible()) {
            operation.withModelProperty(new ExtendingOperationModelProperty(this.extensionType));
        }
    }

    private boolean isExtensible() {
        return this.extensionType.getAnnotation(Extensible.class) != null;
    }

    private void parseParameterRole(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        parameter.withRole(ExtensionModelUtils.roleOf(extensionParameter.getAnnotation(Content.class)));
    }

    private void parseExpressionSupport(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        java.util.Optional<Expression> annotation = extensionParameter.getAnnotation(Expression.class);
        if (annotation.isPresent()) {
            parameter.withExpressionSupport(IntrospectionUtils.getExpressionSupport(annotation.get()));
        }
    }

    private void parseNullSafe(final ExtensionParameter extensionParameter, final ParameterDeclarer parameter) {
        if (extensionParameter.isAnnotatedWith(NullSafe.class)) {
            if (extensionParameter.isRequired() && !extensionParameter.isAnnotatedWith(ParameterGroup.class)) {
                throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is required but annotated with '@%s', which is redundant", extensionParameter.getName(), NullSafe.class.getSimpleName()));
            }
            Class defaultType = extensionParameter.getAnnotation(NullSafe.class).get().defaultImplementingType();
            final boolean hasDefaultOverride = !defaultType.equals(Object.class);
            final MetadataType nullSafeType = hasDefaultOverride ? this.typeLoader.load((java.lang.reflect.Type)defaultType) : parameter.getDeclaration().getType();
            parameter.getDeclaration().getType().accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

                protected void visitBasicType(MetadataType metadataType) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex types (Pojos, Lists, Maps)", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                }

                public void visitArrayType(ArrayType arrayType) {
                    if (hasDefaultOverride) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Collections", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                }

                public void visitObject(ObjectType objectType) {
                    if (hasDefaultOverride && ExtensionMetadataTypeUtils.isInstantiable((MetadataType)objectType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of concrete type '%s', but a 'defaultImplementingType' was provided. Type override is not allowed for concrete types", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (!ExtensionMetadataTypeUtils.isInstantiable(nullSafeType)) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' but is of type '%s'. That annotation can only be used with complex instantiable types (Pojos, Lists, Maps)", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                    if (!JavaTypeUtils.getType((MetadataType)parameter.getDeclaration().getType()).isAssignableFrom(JavaTypeUtils.getType((MetadataType)nullSafeType))) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' of type '%s', but provided type '%s is not a subtype of the parameter's type", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName(), JavaTypeUtils.getType((MetadataType)nullSafeType).getName()));
                    }
                }

                public void visitDictionary(DictionaryType dictionaryType) {
                    if (hasDefaultOverride) {
                        throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' is of type '%s' but a 'defaultImplementingType' was provided. Type override is not allowed for Maps", extensionParameter.getName(), NullSafe.class.getSimpleName(), extensionParameter.getType().getName()));
                    }
                }
            });
            parameter.withModelProperty((ModelProperty)new NullSafeModelProperty(nullSafeType));
        }
    }

    private void parseLayout(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        MuleExtensionAnnotationParser.parseLayoutAnnotations(extensionParameter, LayoutModel.builder()).ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withLayout(arg_0));
    }

    private void parseXmlHints(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        extensionParameter.getAnnotation(XmlHints.class).ifPresent(hints -> parameter.withDsl(ElementDslModel.builder().allowsInlineDefinition(hints.allowInlineDefinition()).allowsReferences(hints.allowReferences()).allowTopLevelDefinition(hints.allowTopLevelDefinition()).build()));
    }

    private void checkAnnotationsNotUsedMoreThanOnce(List<? extends ExtensionParameter> parameters, Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            long count = parameters.stream().filter(param -> param.isAnnotatedWith(annotation)).count();
            if (count <= 1L) continue;
            throw new IllegalModelDefinitionException(String.format("The defined parameters %s from %s, uses the annotation @%s more than once", parameters.stream().map(p -> p.getName()).collect(Collectors.toList()), parameters.get(0).getOwnerDescription(), annotation.getSimpleName()));
        }
    }

    private void addTypeRestrictions(WithAnnotations withAnnotations, ParameterDeclarer parameter) {
        java.util.Optional<RestrictedTo> typeRestriction = withAnnotations.getAnnotation(RestrictedTo.class);
        if (typeRestriction.isPresent()) {
            parameter.withModelProperty(new TypeRestrictionModelProperty(typeRestriction.get().value()));
        }
    }

    private void addImplementingTypeModelProperty(ExtensionParameter extensionParameter, ParameterDeclarer parameter) {
        AnnotatedElement element = extensionParameter.getDeclaringElement();
        parameter.withModelProperty((ModelProperty)(element instanceof Field ? new DeclaringMemberModelProperty((Field)element) : new ImplementingParameterModelProperty((Parameter)element)));
    }

    private void addPagedOperationModelProperty(MethodElement operationMethod, OperationDeclarer operation, boolean supportsConfig) {
        if (PagingProvider.class.isAssignableFrom(operationMethod.getReturnType())) {
            if (!supportsConfig) {
                throw new IllegalOperationModelDefinitionException(String.format("Paged operation '%s' is defined at the extension level but it requires a config, since connections are required for paging", operationMethod.getName()));
            }
            operation.withModelProperty((ModelProperty)new PagedOperationModelProperty());
        }
    }

    private void addInterceptingCallbackModelProperty(MethodElement operationMethod, OperationDeclarer operation) {
        if (InterceptingCallback.class.isAssignableFrom(operationMethod.getReturnType())) {
            operation.withModelProperty((ModelProperty)new InterceptingModelProperty());
        }
    }

    private static /* synthetic */ void lambda$declareParameters$7(ExtensionParameter extensionParameter, ParameterDeclarer parameter, ParameterDeclarationContext declarationContext, ParameterDeclarerContributor contributor) {
        contributor.contribute(extensionParameter, parameter, declarationContext);
    }
}

