/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.manager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.introspection.declaration.Describer;
import org.mule.module.extension.internal.introspection.ExtensionDiscoverer;
import org.mule.util.Preconditions;

final class DefaultExtensionDiscoverer
implements ExtensionDiscoverer {
    private final ExtensionFactory extensionFactory;
    private final ServiceRegistry serviceRegistry;

    public DefaultExtensionDiscoverer(ExtensionFactory extensionFactory, ServiceRegistry serviceRegistry) {
        this.extensionFactory = extensionFactory;
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public List<Extension> discover(ClassLoader classLoader) {
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"classloader cannot be null");
        Collection describers = this.serviceRegistry.lookupProviders(Describer.class, classLoader);
        if (describers.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Describer describer : describers) {
            builder.add((Object)this.extensionFactory.createFrom(describer.describe()));
        }
        return builder.build();
    }
}

