/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.extension.introspection.Capable;
import org.mule.module.extension.internal.util.CapabilityUtils;
import org.mule.util.Preconditions;

public class ParameterGroup
implements Capable {
    private final Class<?> type;
    private final Field field;
    private final Map<String, Field> parameters = new HashMap<String, Field>();
    private Set<Object> capabilities = new HashSet<Object>();

    public ParameterGroup(Class<?> type, Field field) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"type cannot be null");
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"field cannot be null");
        this.type = type;
        this.field = field;
        field.setAccessible(true);
    }

    public ParameterGroup addParameter(String name, Field field) {
        this.parameters.put(name, field);
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Field getField() {
        return this.field;
    }

    public Map<String, Field> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    public void addCapability(Object capability) {
        Preconditions.checkArgument((capability != null ? 1 : 0) != 0, (String)"cannot add a null capability");
        this.capabilities.add(capability);
    }

    public <T> Set<T> getCapabilities(Class<T> capabilityType) {
        return CapabilityUtils.getCapabilities(this.capabilities, capabilityType);
    }

    public boolean isCapableOf(Class<?> capabilityType) {
        return CapabilityUtils.isCapableOf(this.capabilities, capabilityType);
    }
}

