/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime.processor;

import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.extension.introspection.Operation;
import org.mule.extension.runtime.OperationContext;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.runtime.DefaultOperationContext;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;

public final class OperationMessageProcessor
implements MessageProcessor,
MuleContextAware {
    private final String configurationInstanceProviderName;
    private final Operation operation;
    private final ResolverSet resolverSet;
    private MuleContext muleContext;

    public OperationMessageProcessor(Operation operation, String configurationInstanceProviderName, ResolverSet resolverSet) {
        this.operation = operation;
        this.configurationInstanceProviderName = configurationInstanceProviderName;
        this.resolverSet = resolverSet;
    }

    private OperationContext createOperationContext(MuleEvent event) throws MuleException {
        ResolverSetResult parameters = this.resolverSet.resolve(event);
        return new DefaultOperationContext(this.operation, parameters, event);
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        OperationContext operationContext = this.createOperationContext(event);
        Future<Object> future = this.executeOperation(operationContext);
        Object result = this.extractResult(event, future);
        if (result instanceof MuleEvent) {
            return (MuleEvent)result;
        }
        if (result instanceof MuleMessage) {
            event.setMessage((MuleMessage)result);
        } else {
            event.getMessage().setPayload(result);
        }
        return event;
    }

    private Object extractResult(MuleEvent event, Future<Object> future) throws MuleException {
        try {
            return future.get();
        }
        catch (Exception e) {
            throw this.handledException("Could not execute operation " + this.operation.getName(), event, e);
        }
    }

    private Future<Object> executeOperation(OperationContext operationContext) throws MuleException {
        OperationExecutor executor = StringUtils.isBlank((String)this.configurationInstanceProviderName) ? this.muleContext.getExtensionManager().getOperationExecutor(operationContext) : this.muleContext.getExtensionManager().getOperationExecutor(this.configurationInstanceProviderName, operationContext);
        try {
            return executor.execute(operationContext);
        }
        catch (Exception e) {
            throw this.handledException(String.format("Operation %s threw exception", this.operation.getName()), ((OperationContextAdapter)operationContext).getEvent(), e);
        }
    }

    private MuleException handledException(String message, MuleEvent event, Exception e) {
        return new MessagingException(MessageFactory.createStaticMessage((String)message), event, (Throwable)e, (MessageProcessor)this);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

