/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.lang.reflect.Method;
import org.mule.extension.introspection.declaration.OperationExecutorFactory;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.runtime.ReflectiveDelegateFactory;
import org.mule.module.extension.internal.runtime.ReflectiveMethodOperationExecutor;
import org.mule.module.extension.internal.runtime.ReturnDelegate;
import org.mule.module.extension.internal.runtime.ValueReturnDelegate;
import org.mule.module.extension.internal.runtime.VoidReturnDelegate;
import org.mule.module.extension.internal.util.IntrospectionUtils;
import org.mule.util.Preconditions;

public final class ReflectiveOperationExecutorFactory<T>
implements OperationExecutorFactory {
    private final Class<T> implementationClass;
    private final Method operationMethod;
    private final ReturnDelegate returnDelegate;
    private final ReflectiveDelegateFactory delegateFactory;

    public ReflectiveOperationExecutorFactory(Class<T> implementationClass, Method operationMethod, ReflectiveDelegateFactory delegateFactory) {
        Preconditions.checkArgument((implementationClass != null ? 1 : 0) != 0, (String)"operation implementation class cannot be null");
        Preconditions.checkArgument((operationMethod != null ? 1 : 0) != 0, (String)"operation method cannot be null");
        Preconditions.checkArgument((delegateFactory != null ? 1 : 0) != 0, (String)"delegateFactory cannot be null");
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
        this.delegateFactory = delegateFactory;
        this.returnDelegate = IntrospectionUtils.isVoid(operationMethod) ? VoidReturnDelegate.INSTANCE : ValueReturnDelegate.INSTANCE;
    }

    public <C> OperationExecutor getExecutor(C configurationInstance) {
        T executorDelegate = this.delegateFactory.getDelegate(this.implementationClass, configurationInstance);
        return new ReflectiveMethodOperationExecutor<T>(this.operationMethod, executorDelegate, this.returnDelegate);
    }
}

